/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.internal.core.DependencyOnlyExtractedModelRule;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.DefaultBinaryContainer;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTypeModelRuleExtractor
extends TypeModelRuleExtractor<BinaryType, BinarySpec, BaseBinarySpec> {
    private final Instantiator instantiator;

    public BinaryTypeModelRuleExtractor(Instantiator instantiator) {
        super("binary", BinarySpec.class, BaseBinarySpec.class, BinaryTypeBuilder.class, JavaReflectionUtil.factory((Instantiator)DirectInstantiator.INSTANCE, DefaultBinaryTypeBuilder.class, (Object[])new Object[0]));
        this.instantiator = instantiator;
    }

    @Override
    protected <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> ruleDefinition, ModelType<? extends BinarySpec> type, TypeBuilderInternal<BinarySpec> builder) {
        ImmutableList dependencies = ImmutableList.of(ComponentModelBasePlugin.class);
        ModelType implementation = this.determineImplementationType(type, builder);
        if (implementation != null) {
            RegistrationAction mutator = new RegistrationAction(type, implementation, ruleDefinition.getDescriptor(), this.instantiator);
            return new ExtractedModelAction(ModelActionRole.Defaults, (List)dependencies, (ModelAction)mutator);
        }
        return new DependencyOnlyExtractedModelRule((List)dependencies);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationAction
    implements ModelAction<DefaultBinaryContainer> {
        private final ModelType<? extends BinarySpec> publicType;
        private final ModelType<? extends BaseBinarySpec> implementationType;
        private final ModelRuleDescriptor descriptor;
        private final Instantiator instantiator;
        private final ModelReference<DefaultBinaryContainer> subject;
        private final List<ModelReference<?>> inputs;

        public RegistrationAction(ModelType<? extends BinarySpec> publicType, ModelType<? extends BaseBinarySpec> implementationType, ModelRuleDescriptor descriptor, Instantiator instantiator) {
            this.publicType = publicType;
            this.implementationType = implementationType;
            this.descriptor = descriptor;
            this.instantiator = instantiator;
            this.subject = ModelReference.of(DefaultBinaryContainer.class);
            this.inputs = Collections.singletonList(ModelReference.of(ITaskFactory.class));
        }

        public ModelReference<DefaultBinaryContainer> getSubject() {
            return this.subject;
        }

        public ModelRuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        public List<ModelReference<?>> getInputs() {
            return this.inputs;
        }

        public void execute(MutableModelNode modelNode, DefaultBinaryContainer binaries, final List<ModelView<?>> inputs) {
            Class publicClass = this.publicType.getConcreteClass();
            binaries.registerFactory(publicClass, new NamedDomainObjectFactory<BaseBinarySpec>(){

                public BaseBinarySpec create(String name) {
                    return BaseBinarySpec.create(RegistrationAction.this.implementationType.getConcreteClass(), name, RegistrationAction.this.instantiator, (ITaskFactory)ModelViews.assertType((ModelView)((ModelView)inputs.get(0)), (ModelType)ModelType.of(ITaskFactory.class)).getInstance());
                }
            }, this.descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultBinaryTypeBuilder
    extends AbstractTypeBuilder<BinarySpec>
    implements BinaryTypeBuilder<BinarySpec> {
        public DefaultBinaryTypeBuilder() {
            super(BinaryType.class);
        }
    }
}

