/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.BiAction;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.DefaultCollectionBuilder;
import org.gradle.model.internal.core.DelegatingCollectionBuilder;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;
import org.gradle.platform.base.internal.registry.CollectionBuilderBasedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBinariesModelRuleExtractor
extends AbstractAnnotationDrivenComponentModelRuleExtractor<ComponentBinaries> {
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition) {
        return this.createRegistration(ruleDefinition);
    }

    private <R, S extends BinarySpec> ExtractedModelRule createRegistration(MethodRuleDefinition<R, ?> ruleDefinition) {
        try {
            AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector(this);
            this.visitAndVerifyMethodSignature(dataCollector, ruleDefinition);
            Class binaryType = dataCollector.getParameterType(BinarySpec.class);
            Class componentType = dataCollector.getParameterType(ComponentSpec.class);
            ModelReference subject = ModelReference.of((ModelPath)ModelPath.path((String)"binaries"), (ModelType)DefaultCollectionBuilder.typeOf((ModelType)ModelType.of(BinarySpec.class)));
            ComponentBinariesRule componentBinariesRule = new ComponentBinariesRule((ModelReference<CollectionBuilder<BinarySpec>>)subject, componentType, binaryType, ruleDefinition);
            return new ExtractedModelAction(ModelActionRole.Mutate, (List)ImmutableList.of(ComponentModelBasePlugin.class), componentBinariesRule);
        }
        catch (InvalidModelException e) {
            throw this.invalidModelRule(ruleDefinition, e);
        }
    }

    private void visitAndVerifyMethodSignature(AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector, MethodRuleDefinition<?, ?> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        this.visitCollectionBuilderSubject(dataCollector, ruleDefinition, BinarySpec.class);
        this.visitDependency(dataCollector, ruleDefinition, ModelType.of(ComponentSpec.class));
    }

    protected InvalidModelRuleDeclarationException invalidModelRule(MethodRuleDefinition<?, ?> ruleDefinition, InvalidModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(" is not a valid ComponentBinaries model rule method.");
        return new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentBinariesRule<R, S extends BinarySpec>
    extends CollectionBuilderBasedRule<R, S, ComponentSpec, CollectionBuilder<BinarySpec>> {
        private final Class<? extends ComponentSpec> componentType;
        private final Class<S> binaryType;

        public ComponentBinariesRule(ModelReference<CollectionBuilder<BinarySpec>> subject, Class<? extends ComponentSpec> componentType, Class<S> binaryType, MethodRuleDefinition<R, ?> ruleDefinition) {
            super(subject, componentType, ruleDefinition, ModelReference.of(ComponentSpecContainer.class));
            this.componentType = componentType;
            this.binaryType = binaryType;
        }

        public void execute(MutableModelNode modelNode, final CollectionBuilder<BinarySpec> binaries, List<ModelView<?>> inputs) {
            ComponentSpecContainer componentSpecs = (ComponentSpecContainer)ModelViews.assertType(inputs.get(0), (ModelType)ModelType.of(ComponentSpecContainer.class)).getInstance();
            for (final ComponentSpec componentSpec : componentSpecs.withType(this.componentType)) {
                CollectionBuilder typed = binaries.withType(this.binaryType);
                DelegatingCollectionBuilder wrapped = new DelegatingCollectionBuilder(typed, ModelType.of(this.binaryType), new BiAction<String, ModelType<? extends S>>(){

                    public void execute(String s, ModelType<? extends S> modelType) {
                        BinarySpec binary = (BinarySpec)binaries.get(s);
                        assert (binary != null) : "binary should not be null";
                        componentSpec.getBinaries().add((Object)binary);
                        BinarySpecInternal binaryInternal = (BinarySpecInternal)binary;
                        FunctionalSourceSet binarySourceSet = ((ComponentSpecInternal)componentSpec).getSources().copy(s);
                        binaryInternal.setBinarySources(binarySourceSet);
                    }
                });
                this.invoke(inputs, wrapped, componentSpec, componentSpecs);
            }
        }
    }
}

