/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import java.util.Iterator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.PluginServiceRegistry;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.platform.base.internal.registry.BinaryTasksModelRuleExtractor;
import org.gradle.platform.base.internal.registry.BinaryTypeModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ComponentBinariesModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ComponentTypeModelRuleExtractor;
import org.gradle.platform.base.internal.registry.LanguageTypeModelRuleExtractor;
import org.gradle.platform.base.internal.toolchain.DefaultToolResolver;
import org.gradle.platform.base.internal.toolchain.ToolChainInternal;
import org.gradle.platform.base.internal.toolchain.ToolResolver;

public class ComponentModelBaseServiceRegistry
implements PluginServiceRegistry {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.addProvider((Object)new GlobalScopeServices());
    }

    public void registerBuildServices(ServiceRegistration registration) {
    }

    public void registerGradleServices(ServiceRegistration registration) {
    }

    public void registerProjectServices(ServiceRegistration registration) {
        registration.addProvider((Object)new ProjectScopeServices());
    }

    private static class GlobalScopeServices {
        private GlobalScopeServices() {
        }

        MethodModelRuleExtractor createLanguageTypePluginInspector() {
            return new LanguageTypeModelRuleExtractor();
        }

        MethodModelRuleExtractor createComponentModelPluginInspector(Instantiator instantiator) {
            return new ComponentTypeModelRuleExtractor(instantiator);
        }

        MethodModelRuleExtractor createBinaryTypeModelPluginInspector(Instantiator instantiator) {
            return new BinaryTypeModelRuleExtractor(instantiator);
        }

        MethodModelRuleExtractor createComponentBinariesPluginInspector() {
            return new ComponentBinariesModelRuleExtractor();
        }

        MethodModelRuleExtractor createBinaryTaskPluginInspector() {
            return new BinaryTasksModelRuleExtractor();
        }
    }

    private static class ProjectScopeServices {
        private ProjectScopeServices() {
        }

        ToolResolver createToolResolver(ServiceRegistry services) {
            DefaultToolResolver toolResolver = new DefaultToolResolver();
            Iterator i$ = services.getAll(ToolChainInternal.class).iterator();
            while (i$.hasNext()) {
                ToolChainInternal toolChain;
                ToolChainInternal converted = toolChain = (ToolChainInternal)i$.next();
                toolResolver.registerToolChain(converted);
            }
            return toolResolver;
        }
    }
}

