/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultFunctionalSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.internal.core.DependencyOnlyExtractedModelRule;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.internal.DefaultComponentSpecContainer;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeModelRuleExtractor
extends TypeModelRuleExtractor<ComponentType, ComponentSpec, BaseComponentSpec> {
    private Instantiator instantiator;

    public ComponentTypeModelRuleExtractor(Instantiator instantiator) {
        super("component", ComponentSpec.class, BaseComponentSpec.class, ComponentTypeBuilder.class, JavaReflectionUtil.factory((Instantiator)DirectInstantiator.INSTANCE, DefaultComponentTypeBuilder.class, (Object[])new Object[0]));
        this.instantiator = instantiator;
    }

    @Override
    protected <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> ruleDefinition, ModelType<? extends ComponentSpec> type, TypeBuilderInternal<ComponentSpec> builder) {
        ImmutableList dependencies = ImmutableList.of(ComponentModelBasePlugin.class);
        ModelType implementation = this.determineImplementationType(type, builder);
        if (implementation != null) {
            RegistrationAction mutator = new RegistrationAction(type, implementation, ruleDefinition.getDescriptor(), this.instantiator);
            return new ExtractedModelAction(ModelActionRole.Defaults, (List)dependencies, (ModelAction)mutator);
        }
        return new DependencyOnlyExtractedModelRule((List)dependencies);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationAction
    implements ModelAction<DefaultComponentSpecContainer> {
        private final ModelType<? extends ComponentSpec> publicType;
        private final ModelType<? extends BaseComponentSpec> implementationType;
        private final ModelRuleDescriptor descriptor;
        private final Instantiator instantiator;
        private final ModelReference<DefaultComponentSpecContainer> subject;
        private final List<ModelReference<?>> inputs;

        public RegistrationAction(ModelType<? extends ComponentSpec> publicType, ModelType<? extends BaseComponentSpec> implementationType, ModelRuleDescriptor descriptor, Instantiator instantiator) {
            this.publicType = publicType;
            this.implementationType = implementationType;
            this.descriptor = descriptor;
            this.instantiator = instantiator;
            this.subject = ModelReference.of(DefaultComponentSpecContainer.class);
            this.inputs = Arrays.asList(ModelReference.of(ProjectIdentifier.class), ModelReference.of(ProjectSourceSet.class));
        }

        public ModelReference<DefaultComponentSpecContainer> getSubject() {
            return this.subject;
        }

        public ModelRuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        public List<ModelReference<?>> getInputs() {
            return this.inputs;
        }

        public void execute(MutableModelNode modelNode, DefaultComponentSpecContainer components, List<ModelView<?>> inputs) {
            final ProjectIdentifier projectIdentifier = (ProjectIdentifier)ModelViews.assertType(inputs.get(0), (ModelType)ModelType.of(ProjectIdentifier.class)).getInstance();
            final ProjectSourceSet projectSourceSet = (ProjectSourceSet)ModelViews.assertType(inputs.get(1), (ModelType)ModelType.of(ProjectSourceSet.class)).getInstance();
            Class publicClass = this.publicType.getConcreteClass();
            components.registerFactory(publicClass, new NamedDomainObjectFactory<BaseComponentSpec>(){

                public BaseComponentSpec create(String name) {
                    FunctionalSourceSet componentSourceSet = (FunctionalSourceSet)RegistrationAction.this.instantiator.newInstance(DefaultFunctionalSourceSet.class, new Object[]{name, RegistrationAction.this.instantiator, projectSourceSet});
                    DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(projectIdentifier.getPath(), name);
                    return BaseComponentSpec.create(RegistrationAction.this.implementationType.getConcreteClass(), id, componentSourceSet, RegistrationAction.this.instantiator);
                }
            }, this.descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultComponentTypeBuilder
    extends AbstractTypeBuilder<ComponentSpec>
    implements ComponentTypeBuilder<ComponentSpec> {
        public DefaultComponentTypeBuilder() {
            super(ComponentType.class);
        }
    }
}

