/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.language.base.internal.registry.RuleBasedLanguageRegistration;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.model.internal.core.DependencyOnlyExtractedModelRule;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.platform.base.internal.builder.LanguageTypeBuilderInternal;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;
import org.gradle.platform.base.internal.util.ImplementationTypeDetermer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageTypeModelRuleExtractor
extends TypeModelRuleExtractor<LanguageType, LanguageSourceSet, BaseLanguageSourceSet> {
    public ImplementationTypeDetermer<LanguageSourceSet, BaseLanguageSourceSet> implementationTypeDetermer = new ImplementationTypeDetermer("language", BaseLanguageSourceSet.class);

    public LanguageTypeModelRuleExtractor() {
        super("language", LanguageSourceSet.class, BaseLanguageSourceSet.class, LanguageTypeBuilder.class, JavaReflectionUtil.factory((Instantiator)DirectInstantiator.INSTANCE, DefaultLanguageTypeBuilder.class, (Object[])new Object[0]));
    }

    @Override
    protected <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> ruleDefinition, ModelType<? extends LanguageSourceSet> type, TypeBuilderInternal<LanguageSourceSet> builder) {
        ImmutableList dependencies = ImmutableList.of(ComponentModelBasePlugin.class);
        ModelType<BaseLanguageSourceSet> implementation = this.implementationTypeDetermer.determineImplementationType(type, builder);
        if (implementation != null) {
            RegisterTypeRule mutator = new RegisterTypeRule(type, implementation, ((LanguageTypeBuilderInternal)builder).getLanguageName(), ruleDefinition.getDescriptor());
            return new ExtractedModelAction(ModelActionRole.Defaults, (List)dependencies, (ModelAction)mutator);
        }
        return new DependencyOnlyExtractedModelRule((List)dependencies);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RegisterTypeRule
    implements ModelAction<LanguageRegistry> {
        private final ModelType<? extends LanguageSourceSet> type;
        private final ModelType<? extends BaseLanguageSourceSet> implementation;
        private String languageName;
        private final ModelRuleDescriptor descriptor;
        private final ModelReference<LanguageRegistry> subject;
        private final List<ModelReference<?>> inputs;

        protected RegisterTypeRule(ModelType<? extends LanguageSourceSet> type, ModelType<? extends BaseLanguageSourceSet> implementation, String languageName, ModelRuleDescriptor descriptor) {
            this.type = type;
            this.implementation = implementation;
            this.languageName = languageName;
            this.descriptor = descriptor;
            this.subject = ModelReference.of(LanguageRegistry.class);
            this.inputs = ImmutableList.of((Object)ModelReference.of(ServiceRegistry.class));
        }

        public ModelReference<LanguageRegistry> getSubject() {
            return this.subject;
        }

        public List<ModelReference<?>> getInputs() {
            return this.inputs;
        }

        public ModelRuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void execute(MutableModelNode modelNode, LanguageRegistry languageRegistry, List<ModelView<?>> inputs) {
            ServiceRegistry serviceRegistry = (ServiceRegistry)ModelViews.assertType(inputs.get(0), (ModelType)ModelType.of(ServiceRegistry.class)).getInstance();
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            Class publicClass = this.type.getConcreteClass();
            Class implementationClass = this.implementation.getConcreteClass();
            languageRegistry.add(new RuleBasedLanguageRegistration(this.languageName, publicClass, implementationClass, instantiator, fileResolver));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultLanguageTypeBuilder
    extends AbstractTypeBuilder<LanguageSourceSet>
    implements LanguageTypeBuilderInternal<LanguageSourceSet> {
        private String languageName;

        public DefaultLanguageTypeBuilder() {
            super(LanguageType.class);
        }

        @Override
        public void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        @Override
        public String getLanguageName() {
            return this.languageName;
        }
    }
}

