/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.toolchain;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.toolchain.DefaultResolvedCompiler;
import org.gradle.platform.base.internal.toolchain.DefaultResolvedTool;
import org.gradle.platform.base.internal.toolchain.ResolvedTool;
import org.gradle.platform.base.internal.toolchain.ToolChainInternal;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.platform.base.internal.toolchain.ToolResolver;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultToolResolver
implements ToolResolver {
    private Set<ToolChainInternal<? extends Platform>> toolChains = Sets.newHashSet();

    public void registerToolChain(ToolChainInternal<? extends Platform> toolChain) {
        this.toolChains.add(toolChain);
    }

    private Class<? extends Platform> getPlatformType(ToolChainInternal<? extends Platform> toolChain) {
        Class<?> toolChainClass = toolChain.getClass();
        Class<?> platformType = null;
        for (Method method : toolChainClass.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals("select") || !Modifier.isPublic(method.getModifiers()) || (parameterTypes = method.getParameterTypes()).length != 1 || !Platform.class.isAssignableFrom(parameterTypes[0])) continue;
            Class<?> converted = parameterTypes[0];
            if (platformType != null && !platformType.isAssignableFrom(converted)) continue;
            platformType = converted;
        }
        return platformType;
    }

    private <P extends Platform> Set<ToolChainInternal<P>> filterToolChains(P platform) {
        HashSet platformToolChains = Sets.newHashSet();
        for (ToolChainInternal<? extends Platform> raw : this.toolChains) {
            if (!this.getPlatformType(raw).isAssignableFrom(platform.getClass())) continue;
            ToolChainInternal<? extends Platform> converted = raw;
            platformToolChains.add(converted);
        }
        return platformToolChains;
    }

    protected <P extends Platform> ToolSearchResult findToolProvider(P requirement) {
        ToolSearchFailure notAvailableResult = new ToolSearchFailure("No tool chains can satisfy the requirement");
        for (ToolChainInternal<P> toolChain : this.filterToolChains(requirement)) {
            ToolProvider result = toolChain.select(requirement);
            if (result.isAvailable()) {
                return result;
            }
            notAvailableResult.addResult(result);
        }
        return notAvailableResult;
    }

    @Override
    public <P extends Platform> ToolSearchResult checkToolAvailability(P requirement) {
        return this.findToolProvider(requirement);
    }

    @Override
    public <T, P extends Platform> ResolvedTool<T> resolve(Class<T> toolType, P requirement) {
        ToolSearchResult toolProvider = this.findToolProvider(requirement);
        if (toolProvider.isAvailable()) {
            return new DefaultResolvedTool<T>((ToolProvider)toolProvider, toolType);
        }
        ResolvedToolSearchFailure notAvailableResult = new ResolvedToolSearchFailure(String.format("No tool chains can provide a tool of type %s", toolType.getSimpleName()));
        notAvailableResult.addResult(toolProvider);
        return notAvailableResult;
    }

    @Override
    public <C extends CompileSpec, P extends Platform> ResolvedTool<Compiler<C>> resolveCompiler(Class<C> specType, P requirement) {
        ToolSearchResult toolProvider = this.findToolProvider(requirement);
        if (toolProvider.isAvailable()) {
            return new DefaultResolvedCompiler<C>((ToolProvider)toolProvider, specType);
        }
        CompilerSearchFailure notAvailableResult = new CompilerSearchFailure(String.format("No tool chains can provide a compiler for type %s", specType.getSimpleName()));
        notAvailableResult.addResult(toolProvider);
        return notAvailableResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToolSearchFailure
    implements ToolSearchResult {
        private final String message;
        Set<ToolSearchResult> results = Sets.newHashSet();

        public ToolSearchFailure(String message) {
            this.message = message;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.message);
            visitor.startChildren();
            for (ToolSearchResult result : this.results) {
                result.explain(visitor);
            }
            visitor.endChildren();
        }

        RuntimeException failure() {
            TreeFormatter formatter = new TreeFormatter();
            this.explain((TreeVisitor<? super String>)formatter);
            return new GradleException(formatter.toString());
        }

        void addResult(ToolSearchResult result) {
            this.results.add(result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerSearchFailure<T extends CompileSpec>
    extends ToolSearchFailure
    implements ResolvedTool<Compiler<T>> {
        public CompilerSearchFailure(String message) {
            super(message);
        }

        @Override
        public Compiler<T> get() {
            throw this.failure();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvedToolSearchFailure<T>
    extends ToolSearchFailure
    implements ResolvedTool<T> {
        public ResolvedToolSearchFailure(String message) {
            super(message);
        }

        @Override
        public T get() {
            throw this.failure();
        }
    }
}

