/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.annotations.NonNull;
import com.android.ide.common.blame.SourcePosition;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

class ReadOnlyDocument {
    @NonNull
    private final String mFileContents;
    @NonNull
    private final List<Integer> myOffsets;
    private File myFile;
    private long myLastModified;

    ReadOnlyDocument(@NonNull File file) throws IOException {
        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
        if (xml.startsWith("\ufeff")) {
            xml = xml.substring(1);
        }
        this.mFileContents = xml;
        this.myFile = file;
        this.myLastModified = file.lastModified();
        this.myOffsets = Lists.newArrayListWithExpectedSize((int)(this.mFileContents.length() / 30));
        for (int i = 0; i < this.mFileContents.length(); ++i) {
            char c = this.mFileContents.charAt(i);
            if (c != '\n') continue;
            this.myOffsets.add(i + 1);
        }
    }

    public boolean isStale() {
        long now = this.myFile.lastModified();
        return now == 0L || this.myLastModified < now;
    }

    int lineOffset(int lineNumber) {
        int index = lineNumber - 1;
        if (index < 0 || index >= this.myOffsets.size()) {
            return -1;
        }
        return this.myOffsets.get(index);
    }

    int lineNumber(int offset) {
        for (int i = 0; i < this.myOffsets.size(); ++i) {
            if (offset >= this.myOffsets.get(i)) continue;
            return i;
        }
        return -1;
    }

    SourcePosition sourcePosition(int offset) {
        for (int i = 0; i < this.myOffsets.size(); ++i) {
            if (offset >= this.myOffsets.get(i)) continue;
            int lineStartOffset = i == 0 ? 0 : this.myOffsets.get(i - 1);
            return new SourcePosition(i, offset - lineStartOffset, offset);
        }
        return SourcePosition.UNKNOWN;
    }

    int findText(@NonNull String needle, int offset) {
        Preconditions.checkPositionIndex((int)offset, (int)this.mFileContents.length());
        return this.mFileContents.indexOf(needle, offset);
    }

    int findTextBackwards(String needle, int offset) {
        Preconditions.checkPositionIndex((int)offset, (int)this.mFileContents.length());
        return this.mFileContents.lastIndexOf(needle, offset);
    }

    char charAt(int offset) {
        return this.mFileContents.charAt(offset);
    }

    String subsequence(int start, int end) {
        return this.mFileContents.substring(start, end == -1 ? this.mFileContents.length() : end);
    }

    String getContents() {
        return this.mFileContents;
    }

    int length() {
        return this.mFileContents.length();
    }
}

