/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private final Set<Class> myExtraProjectModelClasses = new HashSet<Class>();
    private final boolean myIsPreviewMode;

    public ProjectImportAction(boolean isPreviewMode) {
        this.myIsPreviewMode = isPreviewMode;
    }

    public void addExtraProjectModelClasses(Set<Class> projectModelClasses) {
        this.myExtraProjectModelClasses.addAll(projectModelClasses);
    }

    public AllModels execute(BuildController controller) {
        IdeaProject ideaProject;
        IdeaProject ideaProject2 = ideaProject = this.myIsPreviewMode ? (IdeaProject)controller.getModel(BasicIdeaProject.class) : (IdeaProject)controller.getModel(IdeaProject.class);
        if (ideaProject == null || ideaProject.getModules().isEmpty()) {
            return null;
        }
        AllModels allModels = new AllModels(ideaProject);
        this.addExtraProject(controller, allModels, null);
        for (IdeaModule module : ideaProject.getModules()) {
            this.addExtraProject(controller, allModels, module);
        }
        return allModels;
    }

    private void addExtraProject(BuildController controller, AllModels allModels, IdeaModule model) {
        for (Class aClass : this.myExtraProjectModelClasses) {
            try {
                Object extraProject = controller.findModel((Model)model, aClass);
                if (extraProject == null) continue;
                allModels.addExtraProject(extraProject, aClass, model);
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) continue;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    public static class AllModels
    implements Serializable {
        private final Map<String, Object> projectsByPath = new HashMap<String, Object>();
        private final IdeaProject myIdeaProject;
        private BuildEnvironment myBuildEnvironment;

        public AllModels(IdeaProject project) {
            this.myIdeaProject = project;
        }

        public IdeaProject getIdeaProject() {
            return this.myIdeaProject;
        }

        public BuildEnvironment getBuildEnvironment() {
            return this.myBuildEnvironment;
        }

        public void setBuildEnvironment(BuildEnvironment buildEnvironment) {
            this.myBuildEnvironment = buildEnvironment;
        }

        public <T> T getExtraProject(Class<T> modelClazz) {
            return this.getExtraProject(null, modelClazz);
        }

        public <T> T getExtraProject(IdeaModule module, Class<T> modelClazz) {
            Object extraProject = this.projectsByPath.get(this.extractMapKey(modelClazz, module));
            if (modelClazz.isInstance(extraProject)) {
                return (T)extraProject;
            }
            return null;
        }

        public Collection<String> findModulesWithModel(Class modelClazz) {
            ArrayList<String> modules = new ArrayList<String>();
            for (Map.Entry<String, Object> set : this.projectsByPath.entrySet()) {
                if (!modelClazz.isInstance(set.getValue())) continue;
                modules.add(AllModels.extractModulePath(modelClazz, set.getKey()));
            }
            return modules;
        }

        public void addExtraProject(Object project, Class modelClazz) {
            this.projectsByPath.put(this.extractMapKey(modelClazz, null), project);
        }

        public void addExtraProject(Object project, Class modelClazz, IdeaModule module) {
            this.projectsByPath.put(this.extractMapKey(modelClazz, module), project);
        }

        private String extractMapKey(Class modelClazz, IdeaModule module) {
            return modelClazz.getName() + '@' + (module != null ? module.getGradleProject().getPath() : "root" + this.myIdeaProject.getName().hashCode());
        }

        private static String extractModulePath(Class modelClazz, String key) {
            return key.replaceFirst(modelClazz.getName() + '@', "");
        }

        public String toString() {
            return "AllModels{projectsByPath=" + this.projectsByPath + ", myIdeaProject=" + this.myIdeaProject + '}';
        }
    }
}

