/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.aws.s3.S3Client;
import org.gradle.internal.resource.transport.aws.s3.S3ConnectionProperties;
import org.gradle.internal.resource.transport.aws.s3.S3ResourceConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ConnectorFactory
implements ResourceConnectorFactory {
    public Set<String> getSupportedProtocols() {
        return Collections.singleton("s3");
    }

    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        AwsCredentials credentials = (AwsCredentials)connectionDetails.getCredentials(AwsCredentials.class);
        if (credentials == null) {
            throw new IllegalArgumentException("AwsCredentials must be set for S3 backed repository.");
        }
        return new S3ResourceConnector(new S3Client(credentials, new S3ConnectionProperties()));
    }
}

