/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginRequests;
import org.gradle.plugin.use.resolve.internal.NotNonCorePluginOnClasspathCheckPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.util.CollectionUtils;

public class DefaultPluginRequestApplicator
implements PluginRequestApplicator {
    private final PluginRegistry pluginRegistry;
    private final PluginResolver pluginResolver;

    public DefaultPluginRequestApplicator(PluginRegistry pluginRegistry, PluginResolver pluginResolver) {
        this.pluginRegistry = pluginRegistry;
        this.pluginResolver = pluginResolver;
    }

    public void applyPlugins(PluginRequests requests, final ScriptHandler scriptHandler, final @Nullable PluginManagerInternal target, ClassLoaderScope classLoaderScope) {
        if (requests.isEmpty()) {
            this.defineScriptHandlerClassScope(scriptHandler, classLoaderScope);
            return;
        }
        if (target == null) {
            throw new IllegalStateException("Plugin target is 'null' and there are plugin requests");
        }
        final PluginResolver effectivePluginResolver = this.wrapInNotInClasspathCheck(classLoaderScope);
        List results = CollectionUtils.collect((Iterable)requests, (Transformer)new Transformer<Result, PluginRequest>(){

            public Result transform(PluginRequest request) {
                return DefaultPluginRequestApplicator.this.resolveToFoundResult(effectivePluginResolver, request);
            }
        });
        final LinkedHashMap legacyActualPluginIds = Maps.newLinkedHashMap();
        final LinkedHashMap pluginImpls = Maps.newLinkedHashMap();
        if (!results.isEmpty()) {
            RepositoryHandler repositories = scriptHandler.getRepositories();
            NamedDomainObjectList mavenRepos = repositories.withType(MavenArtifactRepository.class);
            final LinkedHashSet repoUrls = Sets.newLinkedHashSet();
            for (final Result result : results) {
                this.applyPlugin(result.request, result.found.getPluginId(), new Runnable(){

                    public void run() {
                        result.found.execute(new PluginResolveContext(){

                            @Override
                            public void addLegacy(PluginId pluginId, String m2RepoUrl, Object dependencyNotation) {
                                legacyActualPluginIds.put(result, pluginId);
                                repoUrls.add(m2RepoUrl);
                                scriptHandler.getDependencies().add("classpath", dependencyNotation);
                            }

                            @Override
                            public void add(PluginImplementation<?> plugin) {
                                pluginImpls.put(result, plugin);
                            }
                        });
                    }
                });
            }
            for (final String m2RepoUrl : repoUrls) {
                boolean repoExists = CollectionUtils.any((Iterable)mavenRepos, (Spec)new Spec<MavenArtifactRepository>(){

                    public boolean isSatisfiedBy(MavenArtifactRepository element) {
                        return element.getUrl().toString().equals(m2RepoUrl);
                    }
                });
                if (repoExists) continue;
                repositories.maven((Action)new Action<MavenArtifactRepository>(){

                    public void execute(MavenArtifactRepository mavenArtifactRepository) {
                        mavenArtifactRepository.setUrl((Object)m2RepoUrl);
                    }
                });
            }
        }
        this.defineScriptHandlerClassScope(scriptHandler, classLoaderScope);
        for (final Map.Entry entry : legacyActualPluginIds.entrySet()) {
            PluginRequest request = ((Result)entry.getKey()).request;
            final PluginId id = (PluginId)entry.getValue();
            this.applyPlugin(request, id, new Runnable(){

                public void run() {
                    target.apply(id.toString());
                }
            });
        }
        for (final Map.Entry entry : pluginImpls.entrySet()) {
            Result result = (Result)entry.getKey();
            this.applyPlugin(result.request, result.found.getPluginId(), new Runnable(){

                public void run() {
                    target.apply((PluginImplementation)entry.getValue());
                }
            });
        }
    }

    private void defineScriptHandlerClassScope(ScriptHandler scriptHandler, ClassLoaderScope classLoaderScope) {
        Configuration classpathConfiguration = scriptHandler.getConfigurations().getByName("classpath");
        Set files = classpathConfiguration.getFiles();
        DefaultClassPath classPath = new DefaultClassPath((Iterable)files);
        classLoaderScope.export((ClassPath)classPath);
        classLoaderScope.lock();
    }

    private PluginResolver wrapInNotInClasspathCheck(ClassLoaderScope classLoaderScope) {
        ClassloaderBackedPluginDescriptorLocator scriptClasspathPluginDescriptorLocator = new ClassloaderBackedPluginDescriptorLocator(classLoaderScope.getParent().getExportClassLoader());
        return new NotNonCorePluginOnClasspathCheckPluginResolver(this.pluginResolver, this.pluginRegistry, (PluginDescriptorLocator)scriptClasspathPluginDescriptorLocator);
    }

    private void applyPlugin(PluginRequest request, PluginId id, Runnable applicator) {
        try {
            try {
                applicator.run();
            }
            catch (UnknownPluginException e) {
                throw new InvalidPluginException(String.format("Could not apply requested plugin %s as it does not provide a plugin with id '%s'. This is caused by an incorrect plugin implementation. Please contact the plugin author(s).", request, id), (Throwable)e);
            }
            catch (Exception e) {
                throw new InvalidPluginException(String.format("An exception occurred applying plugin request %s", request), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)e, request.getScriptDisplayName(), Integer.valueOf(request.getLineNumber()));
        }
    }

    private Result resolveToFoundResult(PluginResolver effectivePluginResolver, PluginRequest request) {
        Result result = new Result(request);
        try {
            effectivePluginResolver.resolve(request, result);
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)new GradleException(String.format("Error resolving plugin %s", request.getDisplayName()), (Throwable)e), request.getScriptDisplayName(), Integer.valueOf(request.getLineNumber()));
        }
        if (!result.isFound()) {
            String message = this.buildNotFoundMessage(request, result);
            UnknownPluginException exception = new UnknownPluginException(message);
            throw new LocationAwareException((Throwable)exception, request.getScriptDisplayName(), Integer.valueOf(request.getLineNumber()));
        }
        return result;
    }

    private String buildNotFoundMessage(PluginRequest pluginRequest, Result result) {
        if (result.notFoundList.isEmpty()) {
            return String.format("Plugin %s was not found", pluginRequest.getDisplayName());
        }
        Formatter sb = new Formatter();
        sb.format("Plugin %s was not found in any of the following sources:%n", pluginRequest.getDisplayName());
        for (NotFound notFound : result.notFoundList) {
            sb.format("%n- %s", notFound.source);
            if (notFound.detail == null) continue;
            sb.format(" (%s)", notFound.detail);
        }
        return sb.toString();
    }

    private static class Result
    implements PluginResolutionResult {
        private final List<NotFound> notFoundList = new LinkedList<NotFound>();
        private final PluginRequest request;
        private PluginResolution found;

        public Result(PluginRequest request) {
            this.request = request;
        }

        public void notFound(String sourceDescription, String notFoundDetail) {
            this.notFoundList.add(new NotFound(sourceDescription, notFoundDetail));
        }

        public void found(String sourceDescription, PluginResolution pluginResolution) {
            this.found = pluginResolution;
        }

        public boolean isFound() {
            return this.found != null;
        }
    }

    private static class NotFound {
        private final String source;
        private final String detail;

        private NotFound(String source, String detail) {
            this.source = source;
            this.detail = detail;
        }
    }
}

