/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.java.decompiler.IdeaDecompiler;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

public class IdeaLogger
extends IFernflowerLogger {
    private static final Logger LOG = Logger.getInstance(IdeaDecompiler.class);
    private String myClass = null;

    @Override
    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        if (this.myClass != null) {
            message = message + " [" + this.myClass + "]";
        }
        if (severity == IFernflowerLogger.Severity.ERROR) {
            LOG.error(message);
        } else if (severity == IFernflowerLogger.Severity.WARN) {
            LOG.warn(message);
        } else if (severity == IFernflowerLogger.Severity.INFO) {
            LOG.info(message);
        } else {
            LOG.debug(message);
        }
    }

    @Override
    public void writeMessage(String message, Throwable t) {
        if (t instanceof InternalException) {
            throw (InternalException)t;
        }
        if (t instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)t;
        }
        if (t instanceof InterruptedException) {
            throw new ProcessCanceledException(t);
        }
        if (this.myClass != null) {
            message = message + " [" + this.myClass + "]";
        }
        throw new InternalException(message, t);
    }

    @Override
    public void startReadingClass(String className) {
        LOG.debug("decompiling class " + className);
        this.myClass = className;
    }

    @Override
    public void endReadingClass() {
        LOG.debug("... class decompiled");
        this.myClass = null;
    }

    @Override
    public void startClass(String className) {
        LOG.debug("processing class " + className);
    }

    @Override
    public void endClass() {
        LOG.debug("... class processed");
    }

    @Override
    public void startMethod(String methodName) {
        LOG.debug("processing method " + methodName);
    }

    @Override
    public void endMethod() {
        LOG.debug("... method processed");
    }

    @Override
    public void startWriteClass(String className) {
        LOG.debug("writing class " + className);
    }

    @Override
    public void endWriteClass() {
        LOG.debug("... class written");
    }

    public static class InternalException
    extends RuntimeException {
        public InternalException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

