/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability;

import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.usability.diagnostics.DiagnosisUtils;
import org.apache.maven.usability.diagnostics.ErrorDiagnoser;

public class ProjectBuildDiagnoser
implements ErrorDiagnoser {
    public boolean canDiagnose(Throwable error) {
        return DiagnosisUtils.containsInCausality(error, ProjectBuildingException.class);
    }

    public String diagnose(Throwable error) {
        ProjectBuildingException pbe = (ProjectBuildingException)DiagnosisUtils.getFromCausality(error, ProjectBuildingException.class);
        StringBuffer message = new StringBuffer();
        message.append("Error building POM (may not be this project's POM).").append("\n\n");
        message.append("\nProject ID: ").append(pbe.getProjectId());
        if (pbe instanceof InvalidProjectModelException) {
            InvalidProjectModelException ipme = (InvalidProjectModelException)pbe;
            message.append("\nPOM Location: ").append(ipme.getPomLocation());
            ModelValidationResult result = ipme.getValidationResult();
            if (result != null) {
                message.append("\nValidation Messages:\n\n").append(ipme.getValidationResult().render("    "));
            }
        }
        message.append("\n\n").append("Reason: ").append(pbe.getMessage());
        message.append("\n\n");
        return message.toString();
    }
}

