/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatObjectIterator;
import gnu.trove.TFloatObjectProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.THash;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatObjectHashMap<V>
extends THash
implements TFloatHashingStrategy {
    protected transient V[] _values;
    protected transient float[] _set;
    protected final TFloatHashingStrategy _hashingStrategy;

    public TFloatObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(TFloatHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TFloatObjectHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TFloatObjectHashMap<V> clone() {
        TFloatObjectHashMap m = (TFloatObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    public TFloatObjectIterator<V> iterator() {
        return new TFloatObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        this._set = new float[capacity];
        return capacity;
    }

    public boolean contains(float val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TFloatProcedure procedure) {
        float[] set = this._set;
        Object[] values = this._values;
        int i = set.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values, i) || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public V put(float key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TFloatObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TFloatObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        this._values[index] = TFloatObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        float[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new float[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(oldVals, i)) continue;
            float o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public V get(float key) {
        int index = this.index(key);
        return index < 0 ? null : (V)TFloatObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        float[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0f;
            values[i] = null;
        }
    }

    public V remove(float key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = TFloatObjectHashMap.unwrapNull(this._values[index]);
            this.removeAt(index);
        }
        return prev;
    }

    protected int index(float val) {
        float[] set = this._set;
        Object[] values = this._values;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TFloatObjectHashMap.isFree(values, index) && (TFloatObjectHashMap.isRemoved(values, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TFloatObjectHashMap.isFree(values, index) && (TFloatObjectHashMap.isRemoved(values, index) || set[index] != val));
        }
        return TFloatObjectHashMap.isFree(values, index) ? -1 : index;
    }

    protected int insertionIndex(float val) {
        int firstRemoved;
        Object[] values = this._values;
        float[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TFloatObjectHashMap.isFree(values, index)) {
            return index;
        }
        if (TFloatObjectHashMap.isFull(values, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TFloatObjectHashMap.isRemoved(values, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TFloatObjectHashMap.isRemoved(values, index)) continue;
            firstRemoved = index;
        } while (TFloatObjectHashMap.isFull(values, index) && set[index] != val);
        if (TFloatObjectHashMap.isRemoved(values, index)) {
            while (!TFloatObjectHashMap.isFree(values, index) && (TFloatObjectHashMap.isRemoved(values, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TFloatObjectHashMap.isFull(values, index)) {
            return -index - 1;
        }
        return firstRemoved == -1 ? index : firstRemoved;
    }

    static boolean isFull(Object[] values, int index) {
        Object value = values[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values, int index) {
        return values[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values, int index) {
        return values[index] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatObjectHashMap)) {
            return false;
        }
        TFloatObjectHashMap that = (TFloatObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values = this._values;
        int i = values.length;
        int j = 0;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values, i)) continue;
            vals[j++] = TFloatObjectHashMap.unwrapNull(values[i]);
        }
        return vals;
    }

    public float[] keys() {
        float[] keys = new float[this.size()];
        float[] k = this._set;
        Object[] values = this._values;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values, i)) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(V val) {
        Object[] values = this._values;
        if (null == val) {
            int i = values.length;
            while (i-- > 0) {
                if (TObjectHash.NULL != values[i]) continue;
                return true;
            }
        } else {
            int i = values.length;
            while (i-- > 0) {
                V value = TFloatObjectHashMap.unwrapNull(values[i]);
                if (!TFloatObjectHashMap.isFull(values, i) || val != value && !val.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values, i) || procedure.execute(TFloatObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatObjectProcedure<V> procedure) {
        float[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TFloatObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TFloatObjectProcedure<V> procedure) {
        boolean modified = false;
        float[] keys = this._set;
        Object[] values = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (!TFloatObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TFloatObjectHashMap.unwrapNull(values[i]))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values, i)) continue;
            values[i] = TFloatObjectHashMap.wrapNull(function.execute(TFloatObjectHashMap.unwrapNull(values[i])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final int computeHashCode(float val) {
        return HashFunctions.hash(val);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<V>
    implements TFloatObjectProcedure<V> {
        private final TFloatObjectHashMap<V> _otherMap;

        EqProcedure(TFloatObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(float key, V value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TFloatObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(float key, V value) {
            this.h += TFloatObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

