/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Tag(value="filter")
public class ResourceRootFilter {
    @Tag(value="filterType")
    public String filterType;
    @Tag(value="properties")
    public String properties;
    private transient Map<Object, Object> propertiesMap;

    public int computeConfigurationHash() {
        int result = this.filterType.hashCode();
        result = 31 * result + ((Object)this.getProperties()).hashCode();
        return result;
    }

    public Map<Object, Object> getProperties() {
        if (this.propertiesMap == null) {
            try {
                Gson gson = new GsonBuilder().create();
                this.propertiesMap = (Map)gson.fromJson(this.properties, new TypeToken<Map<Object, Object>>(){}.getType());
                if ("RenamingCopyFilter".equals(this.filterType)) {
                    Object pattern = this.propertiesMap.get("pattern");
                    Matcher matcher = Pattern.compile(pattern instanceof String ? (String)pattern : "").matcher("");
                    this.propertiesMap.put("matcher", matcher);
                }
            }
            catch (JsonSyntaxException e) {
                throw new RuntimeException("Unsupported filter: " + this.properties, e);
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Unsupported filter: " + this.properties, e);
            }
        }
        return this.propertiesMap;
    }
}

