/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.deploy;

import com.google.common.base.Strings;
import com.google.gct.idea.appengine.deploy.AppEngineUpdater;
import com.google.gct.idea.appengine.dom.AppEngineWebApp;
import com.google.gct.idea.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.idea.elysium.ProjectSelector;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesCombobox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AppEngineUpdateDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AppEngineUpdateDialog.class);
    private static final String DEFAULT_APPID = "myApplicationId";
    private ModulesCombobox myModuleComboBox;
    private ProjectSelector myElysiumProjectId;
    private JTextField myVersion;
    private JPanel myPanel;
    private JBLabel moduleLabel;
    private List<Module> myDeployableModules;
    private Project myProject;
    private Module myInitiallySelectedModule;

    private AppEngineUpdateDialog(Project project, List<Module> deployableModules, Module selectedModule) {
        super(project, true);
        this.myDeployableModules = deployableModules;
        this.myProject = project;
        this.myInitiallySelectedModule = selectedModule;
        this.$$$setupUI$$$();
        this.init();
        this.initValidation();
        this.setTitle("Deploy to App Engine");
        this.setOKButtonText("Deploy");
        Window myWindow = this.getWindow();
        if (myWindow != null) {
            myWindow.setPreferredSize(new Dimension(310, 135));
        }
    }

    static void show(Project project, Module selectedModule) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(module);
            if (facet == null) continue;
            modules.add(module);
        }
        if (modules.size() == 0) {
            Messages.showErrorDialog((String)XmlStringUtil.wrapInHtml((CharSequence)"This project does not contain any App Engine modules. To add an App Engine module for your project, <br> open \u201cFile > New Module\u2026\u201d menu and choose one of App Engine modules."), (String)"Error");
            return;
        }
        if (selectedModule != null && !modules.contains(selectedModule)) {
            selectedModule = null;
        }
        if (selectedModule == null && modules.size() == 1) {
            selectedModule = (Module)modules.get(0);
        }
        Module passedSelectedModule = selectedModule;
        AppEngineUpdateDialog dialog = new AppEngineUpdateDialog(project, modules, passedSelectedModule);
        dialog.show();
    }

    protected JComponent createCenterPanel() {
        SortedComboBoxModel model = (SortedComboBoxModel)this.myModuleComboBox.getModel();
        model.clear();
        model.addAll(this.myDeployableModules);
        if (this.myInitiallySelectedModule != null) {
            model.setSelectedItem((Object)this.myInitiallySelectedModule);
            this.populateFields();
        }
        this.myModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineUpdateDialog.this.populateFields();
            }
        });
        return this.myPanel;
    }

    private void populateFields() {
        this.myElysiumProjectId.setText("");
        this.myVersion.setText("");
        Module appEngineModule = this.myModuleComboBox.getSelectedModule();
        if (appEngineModule != null) {
            AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(appEngineModule);
            if (facet == null) {
                Messages.showErrorDialog((Component)this.getPeer().getOwner(), (String)"Could not acquire App Engine module information.", (String)"Deploy");
                return;
            }
            AppEngineWebApp appEngineWebApp = facet.getAppEngineWebXml();
            if (appEngineWebApp == null) {
                Messages.showErrorDialog((Component)this.getPeer().getOwner(), (String)"Could not locate or parse the appengine-web.xml fle.", (String)"Deploy");
                return;
            }
            String newProjectId = appEngineWebApp.getApplication().getRawText();
            if (!DEFAULT_APPID.equals(newProjectId)) {
                this.myElysiumProjectId.setText(newProjectId);
            }
            this.myVersion.setText(appEngineWebApp.getVersion().getRawText());
        }
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            AppEngineConfigurationProperties model;
            Module selectedModule = this.myModuleComboBox.getSelectedModule();
            String sdk = "";
            String war = "";
            AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(selectedModule);
            if (facet != null && (model = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null) {
                sdk = model.APPENGINE_SDKROOT;
                war = model.WAR_DIR;
            }
            String client_secret = null;
            String client_id = null;
            String refresh_token = null;
            CredentialedUser selectedUser = this.myElysiumProjectId.getSelectedUser();
            if (selectedUser == null) {
                selectedUser = GoogleLogin.getInstance().getActiveUser();
                if (selectedUser != null) {
                    if (Messages.showYesNoDialog((Component)this.getPeer().getOwner(), (String)("The Project ID you entered could not be found.  Do you want to deploy anyway using " + GoogleLogin.getInstance().getActiveUser().getEmail() + " for credentials?"), (String)"Deploy", (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                } else {
                    Messages.showErrorDialog((Component)this.getPeer().getOwner(), (String)"You need to be logged in to deploy.", (String)"Login");
                    return;
                }
            }
            if (selectedUser != null) {
                client_secret = selectedUser.getGoogleLoginState().fetchOAuth2ClientSecret();
                client_id = selectedUser.getGoogleLoginState().fetchOAuth2ClientId();
                refresh_token = selectedUser.getGoogleLoginState().fetchOAuth2RefreshToken();
            }
            if (Strings.isNullOrEmpty(client_secret) || Strings.isNullOrEmpty(client_id) || Strings.isNullOrEmpty(refresh_token)) {
                LOG.error("StartUploading while logged in, but it doesn't have full credentials.");
                if (Strings.isNullOrEmpty((String)client_secret)) {
                    LOG.error("(null) client_secret");
                }
                if (Strings.isNullOrEmpty((String)client_id)) {
                    LOG.error("(null) client_id");
                }
                if (Strings.isNullOrEmpty((String)refresh_token)) {
                    LOG.error("(null) refresh_token");
                }
                Messages.showErrorDialog((Component)this.getPeer().getOwner(), (String)"The project ID is not a valid Google Console Developer Project.", (String)"Login");
                return;
            }
            if (Strings.isNullOrEmpty((String)sdk) || Strings.isNullOrEmpty((String)war) || Strings.isNullOrEmpty((String)this.myElysiumProjectId.getText()) || selectedModule == null) {
                Messages.showErrorDialog((Component)this.getPeer().getOwner(), (String)"Could not deploy due to missing information (sdk/war/projectid).", (String)"Deploy");
                LOG.error("StartUploading was called with bad module/sdk/war");
                return;
            }
            this.close(0);
            new AppEngineUpdater(this.myProject, selectedModule, sdk, war, this.myElysiumProjectId.getText(), this.myVersion.getText(), client_secret, client_id, refresh_token).startUploading();
        }
    }

    protected ValidationInfo doValidate() {
        if (!GoogleLogin.getInstance().isLoggedIn()) {
            return new ValidationInfo("You must be logged in to perform this action.");
        }
        Module module = this.myModuleComboBox.getSelectedModule();
        if (module == null) {
            return new ValidationInfo("Select a module");
        }
        AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(module);
        if (facet == null) {
            return new ValidationInfo("Could not find App Engine gradle configuration on Module");
        }
        if (Strings.isNullOrEmpty((String)this.myElysiumProjectId.getText())) {
            return new ValidationInfo("Please enter a Project ID.");
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ProjectSelector projectSelector;
        JTextField jTextField;
        ModulesCombobox modulesCombobox;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), 2, 2, false, false));
        jPanel.setPreferredSize(new Dimension(275, 135));
        this.moduleLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModuleComboBox = modulesCombobox = new ModulesCombobox();
        jPanel.add((Component)modulesCombobox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Deploy to:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Version:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myVersion = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jTextField.setHorizontalAlignment(2);
        jTextField.setEditable(true);
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myElysiumProjectId = projectSelector = new ProjectSelector();
        jPanel.add((Component)projectSelector, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

