/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.gradle;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.FactoryMap;
import java.io.File;
import java.util.Collections;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataService;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleInvoker {
    private static final Logger LOG = Logger.getInstance(GradleInvoker.class);

    private GradleInvoker() {
    }

    public static void executeTask(String taskName, Module module, TaskCallback callback, ProgressExecutionMode mode) {
        String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (Strings.isNullOrEmpty((String)projectId)) {
            LOG.warn("Error retrieving module gradle id, could not execute gradle task.");
            return;
        }
        String fullTaskName = ExternalSystemApiUtil.getExternalProjectId((Module)module) + taskName;
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(ExternalSystemApiUtil.getExternalProjectPath((Module)module));
        settings.setTaskNames(Collections.singletonList(fullTaskName));
        settings.setScriptParameters("");
        settings.setVmOptions("");
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.toString());
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)DefaultRunExecutor.EXECUTOR_ID, (Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)callback, (ProgressExecutionMode)mode);
    }

    public static ExternalProject getGradleModelItem(Module module) {
        final ExternalProjectDataService externalProjectDataService = (ExternalProjectDataService)((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).getDataService(ExternalProjectDataService.KEY);
        assert (externalProjectDataService != null);
        FactoryMap<String, ExternalProject> lazyExternalProjectMap = new FactoryMap<String, ExternalProject>(){

            protected ExternalProject create(String gradleProjectPath) {
                return externalProjectDataService.getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
            }
        };
        String gradleProjectPath = module.getOptionValue("external.root.project.path");
        if (Strings.isNullOrEmpty((String)gradleProjectPath)) {
            return null;
        }
        ExternalProject externalRootProject = (ExternalProject)lazyExternalProjectMap.get(gradleProjectPath);
        if (externalRootProject == null) {
            return null;
        }
        return externalProjectDataService.findExternalProject(externalRootProject, module);
    }
}

