/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.gradle.project;

import com.google.appengine.gradle.model.AppEngineModel;
import com.google.common.collect.Sets;
import com.google.gct.idea.appengine.gradle.project.IdeaAppEngineProject;
import com.google.gct.idea.appengine.gradle.service.AppEngineGradleProjectDataService;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Order(value=1000)
public class AppEngineGradleProjectResolver
extends AbstractProjectResolverExtension {
    public void populateModuleExtraModels(IdeaModule gradleModule, DataNode<ModuleData> ideModule) {
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)((ModuleData)ideModule.getData()).getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        AppEngineModel appEngineModel = (AppEngineModel)this.resolverCtx.getExtraProject(gradleModule, AppEngineModel.class);
        if (appEngineModel != null) {
            IdeaAppEngineProject ideaAppEngineProject = new IdeaAppEngineProject(gradleModule.getName(), moduleRootDirPath, appEngineModel);
            ideModule.createChild(AppEngineGradleProjectDataService.IDE_APP_ENGINE_PROJECT, (Object)ideaAppEngineProject);
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    public Set<Class> getExtraProjectModelClasses() {
        return Sets.newHashSet((Object[])new Class[]{AppEngineModel.class});
    }
}

