/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.sdk;

import com.google.gct.idea.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.idea.appengine.sdk.AppEngineSdk;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public class AppEngineWebXmlSchemaProvider
extends XmlSchemaProvider {
    public boolean isAvailable(XmlFile file) {
        if (!"appengine-web.xml".equals(file.getName())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(module);
        if (facet != null) {
            AppEngineConfigurationProperties state = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState();
            return state != null && StringUtil.isNotEmpty((String)state.APPENGINE_SDKROOT);
        }
        return false;
    }

    public XmlFile getSchema(@NonNls String url, Module module, PsiFile baseFile) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        File file;
        AppEngineSdk sdk;
        if (module == null) {
            return null;
        }
        if (!url.equals("http://appengine.google.com/ns/1.0")) {
            return null;
        }
        AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(module);
        if (facet != null && (sdk = facet.getAppEngineSdk()) != null && (file = sdk.getXmlDescriptorFile()) != null && (virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file)) != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }
}

