/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.synchronization;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class SampleSyncTask
implements Runnable {
    public static final Logger LOG = Logger.getInstance(SampleSyncTask.class);
    private static SampleSyncTask instance;
    private final String ANDROID_REPO_PATH = System.getProperty("user.home") + "/.android/cloud/templates";
    private final String GITHUB_SAMPLE_LINK = "https://github.com/GoogleCloudPlatform/gradle-appengine-templates.git";
    private final String LOCAL_REPO_PATH;
    private final String SAMPLE_LINK;

    public static SampleSyncTask getInstance() {
        if (instance == null) {
            instance = new SampleSyncTask();
        }
        return instance;
    }

    @Override
    public void run() {
        this.updateSampleRepo();
    }

    public SampleSyncTask(String testRepoDirectory, String testSampleLink) {
        this.LOCAL_REPO_PATH = testRepoDirectory;
        this.SAMPLE_LINK = testSampleLink;
    }

    private SampleSyncTask() {
        this.LOCAL_REPO_PATH = this.ANDROID_REPO_PATH;
        this.SAMPLE_LINK = "https://github.com/GoogleCloudPlatform/gradle-appengine-templates.git";
    }

    private void updateSampleRepo() {
        Git localGitRepo = this.getLocalRepo();
        if (localGitRepo == null) {
            localGitRepo = this.cloneGithubRepo();
        } else {
            try {
                localGitRepo.pull().call();
            }
            catch (GitAPIException e) {
                LOG.error("Error syncing local sample repository", (Throwable)e);
            }
        }
        if (localGitRepo != null) {
            localGitRepo.getRepository().close();
        }
    }

    private Git getLocalRepo() {
        File localRepo = new File(this.LOCAL_REPO_PATH);
        if (localRepo.exists()) {
            try {
                return Git.open((File)localRepo);
            }
            catch (IOException e) {
                LOG.error("Error getting the local sample repository", (Throwable)e);
            }
        }
        return null;
    }

    private Git cloneGithubRepo() {
        File localRepoDirectory = new File(this.LOCAL_REPO_PATH);
        if (localRepoDirectory.exists()) {
            try {
                FileUtils.forceDelete((File)localRepoDirectory);
            }
            catch (IOException e) {
                LOG.error("Error deleting " + this.LOCAL_REPO_PATH, (Throwable)e);
            }
        }
        try {
            Git localGitRepo = Git.cloneRepository().setURI(this.SAMPLE_LINK).setDirectory(new File(this.LOCAL_REPO_PATH)).call();
            return localGitRepo;
        }
        catch (GitAPIException e) {
            LOG.error("Error cloning github sample repository: " + this.SAMPLE_LINK, (Throwable)e);
            return null;
        }
    }
}

