/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.util;

import com.google.gct.idea.appengine.util.PsiUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NonNls;

public class EndpointUtilities {
    public static String removeBeginningAndEndingQuotes(String input) {
        if (input == null || !input.startsWith("\"") || !input.endsWith("\"")) {
            return input;
        }
        return input.substring(1, input.length() - 1);
    }

    public static boolean isEndpointClass(PsiElement psiElement) {
        PsiClass psiClass = PsiUtils.findClass(psiElement);
        if (psiClass == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"com.google.api.server.spi.config.Api", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"com.google.api.server.spi.config.ApiClass", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"com.google.api.server.spi.config.ApiReference", (boolean)true);
    }

    public static boolean isApiMethod(@NonNls PsiMethod psiMethod) {
        PsiModifierList psiModifierList = psiMethod.getModifierList();
        return psiModifierList.hasModifierProperty("public") && !psiModifierList.hasModifierProperty("static");
    }

    public static String collapseSequenceOfDots(String word) {
        return word.replaceAll("[.]+", ".");
    }

    public static boolean isPublicNullaryConstructor(PsiMethod method) {
        if (!method.isConstructor()) {
            return false;
        }
        if (method.getParameterList().getParametersCount() > 0) {
            return false;
        }
        PsiModifierList modifierList = method.getModifierList();
        return modifierList.hasModifierProperty("public");
    }
}

