/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;

public class PsiUtils {
    private PsiUtils() {
    }

    public static PsiClass getPublicAnnotatedClass(PsiJavaFile psiJavaFile, String annotationFqn) {
        PsiClass[] classes;
        for (PsiClass cls : classes = psiJavaFile.getClasses()) {
            PsiModifierList modifierList = cls.getModifierList();
            if (modifierList == null || !modifierList.hasExplicitModifier("public") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)cls, (String)annotationFqn, (boolean)false)) continue;
            return cls;
        }
        return null;
    }

    public static PsiField getAnnotatedFieldFromClass(PsiClass entityClass, String annotationFqn) {
        for (PsiField field : entityClass.getAllFields()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)annotationFqn, (boolean)false)) continue;
            return field;
        }
        return null;
    }

    public static PsiFile addOrReplaceFile(PsiDirectory dir, PsiFile file) {
        PsiFile existingFile = dir.findFile(file.getName());
        if (existingFile != null) {
            existingFile.delete();
        }
        return (PsiFile)dir.add((PsiElement)file);
    }

    public static PsiFile addIfMissingFile(PsiDirectory dir, PsiFile file) {
        PsiFile existingFile = dir.findFile(file.getName());
        if (existingFile != null) {
            return existingFile;
        }
        return (PsiFile)dir.add((PsiElement)file);
    }

    public static PsiDirectory addOrReplaceDirectory(PsiDirectory parent, String dirName) {
        PsiUtils.deleteIfExists(parent, dirName);
        return parent.createSubdirectory(dirName);
    }

    public static PsiDirectory addIfMissingDirectory(PsiDirectory parent, String dirName) {
        PsiDirectory existingDir = parent.findSubdirectory(dirName);
        if (existingDir != null) {
            return existingDir;
        }
        return parent.createSubdirectory(dirName);
    }

    public static void deleteIfExists(PsiDirectory parent, String dirName) {
        PsiDirectory existingDir = parent.findSubdirectory(dirName);
        if (existingDir != null) {
            existingDir.delete();
        }
    }

    public static PsiFile createFormattedFile(Project project, String filename, FileType fileType, String fileContents) {
        PsiFile rawFile = PsiFileFactory.getInstance((Project)project).createFileFromText(filename, fileType, (CharSequence)fileContents);
        PsiFile formattedFile = (PsiFile)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)rawFile);
        return formattedFile;
    }

    public static PsiClass findClass(PsiElement element) {
        return element instanceof PsiClass ? (PsiClass)element : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    public static PsiJavaFile getPsiJavaFileFromContext(AnActionEvent actionEvent) {
        PsiFile psiFile = (PsiFile)actionEvent.getData(LangDataKeys.PSI_FILE);
        if (psiFile == null || !(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        return (PsiJavaFile)psiFile;
    }

    public static boolean isParameterizedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        return Boolean.TRUE == type.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            public Boolean visitClassType(PsiClassType classType) {
                return classType.getParameterCount() > 0;
            }
        });
    }
}

