/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class ApiParameterInspection
extends EndpointInspectionBase {
    public String getStaticDescription() {
        return EndpointBundle.message("api.parameter.description", new Object[0]);
    }

    public String getDisplayName() {
        return EndpointBundle.message("api.parameter.name", new Object[0]);
    }

    public String getShortName() {
        return EndpointBundle.message("api.parameter.short.name", new Object[0]);
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitParameter(PsiParameter psiParameter) {
                Project project;
                if (!EndpointUtilities.isEndpointClass((PsiElement)psiParameter)) {
                    return;
                }
                PsiElement psiElement = psiParameter.getDeclarationScope();
                if (psiElement instanceof PsiMethod) {
                    if (!EndpointUtilities.isApiMethod((PsiMethod)psiElement)) {
                        return;
                    }
                    if (((PsiMethod)psiElement).isConstructor()) {
                        return;
                    }
                } else {
                    return;
                }
                try {
                    project = psiParameter.getContainingFile().getProject();
                    if (project == null) {
                        return;
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    EndpointInspectionBase.LOG.error("Cannot determine project with parameter " + psiParameter.getText(), (Throwable)e);
                    return;
                }
                PsiType psiType = psiParameter.getType();
                if (!this.isApiParameter(psiType, project)) {
                    return;
                }
                if (!ApiParameterInspection.this.hasParameterName(psiParameter)) {
                    holder.registerProblem((PsiElement)psiParameter, "Missing parameter name. Parameter type (" + psiType.getPresentableText() + ") is not an entity type and thus should be annotated with @Named.", new LocalQuickFix[]{new MyQuickFix()});
                }
            }
        };
    }

    private boolean hasParameterName(PsiParameter psiParameter) {
        PsiModifierList modifierList = psiParameter.getModifierList();
        if (modifierList == null) {
            return false;
        }
        PsiAnnotation annotation = modifierList.findAnnotation("javax.inject.Named");
        if (annotation != null) {
            return true;
        }
        annotation = modifierList.findAnnotation("com.google.api.server.spi.config.Named");
        return annotation != null;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        public String getName() {
            return this.getFamilyName() + ": Add @Named";
        }

        public String getFamilyName() {
            return ApiParameterInspection.this.getDisplayName();
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            if (!(element instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)element;
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (modifierList.findAnnotation("com.google.api.server.spi.config.Named") != null) {
                return;
            }
            if (modifierList.findAnnotation("") != null) {
                return;
            }
            String annotationString = "@Named(\"" + parameter.getName() + "\")";
            PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(annotationString, element);
            modifierList.add((PsiElement)annotation);
            PsiFile file = parameter.getContainingFile();
            if (file == null) {
                return;
            }
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiAdapter.addImportStatement((PsiJavaFile)((PsiJavaFile)file), (String)"com.google.api.server.spi.config.Named");
        }
    }
}

