/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.PsiUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EndpointPsiElementVisitor
extends JavaElementVisitor {
    private static final String API_TRANSFORMER_ATTRIBUTE = "transformers";

    public boolean hasTransformer(PsiElement psiElement) {
        PsiAnnotationMemberValue transformerMember;
        PsiClass psiClass = PsiUtils.findClass(psiElement);
        if (psiClass == null) {
            return false;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        PsiAnnotation apiTransformerAnnotation = modifierList.findAnnotation("com.google.api.server.spi.config.ApiTransformer");
        if (apiTransformerAnnotation != null) {
            return true;
        }
        PsiAnnotation apiAnnotation = modifierList.findAnnotation("com.google.api.server.spi.config.Api");
        return apiAnnotation != null && (transformerMember = apiAnnotation.findAttributeValue(API_TRANSFORMER_ATTRIBUTE)) != null && !transformerMember.getText().equals("{}");
    }

    public PsiAnnotationMemberValue getNamedAnnotationValue(PsiParameter psiParameter) {
        PsiModifierList modifierList = psiParameter.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation annotation = modifierList.findAnnotation("javax.inject.Named");
        if (annotation == null && (annotation = modifierList.findAnnotation("com.google.api.server.spi.config.Named")) == null) {
            return null;
        }
        PsiNameValuePair[] nameValuePairs = annotation.getParameterList().getAttributes();
        if (nameValuePairs.length != 1) {
            return null;
        }
        if (nameValuePairs[0] == null) {
            return null;
        }
        return nameValuePairs[0].getValue();
    }

    private static Set<PsiClassType> createParameterTypes(Project project) {
        HashSet<PsiClassType> parameterTypes = new HashSet<PsiClassType>();
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Enum"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.String"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Boolean"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Integer"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Long"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Float"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Double"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.util.Date"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("com.google.api.server.spi.types.DateAndTime"));
        parameterTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("com.google.api.server.spi.types.SimpleDate"));
        return Collections.unmodifiableSet(parameterTypes);
    }

    private static Set<PsiClassType> createInjectedClassTypes(Project project) {
        HashSet<PsiClassType> injectedClassTypes = new HashSet<PsiClassType>();
        injectedClassTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("com.google.appengine.api.users.User"));
        injectedClassTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("javax.servlet.http.HttpServletRequest"));
        injectedClassTypes.add(JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("javax.servlet.ServletContext"));
        return Collections.unmodifiableSet(injectedClassTypes);
    }

    public boolean isApiParameter(PsiType psiType, Project project) {
        PsiType baseType = psiType;
        PsiClassType collectionType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.util.Collection");
        if (psiType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            baseType = arrayType.getDeepComponentType();
        } else if (collectionType.isAssignableFrom(psiType)) {
            assert (psiType instanceof PsiClassType);
            PsiClassType classType = (PsiClassType)psiType;
            PsiType[] parameters = classType.getParameters();
            if (parameters.length == 0) {
                return false;
            }
            baseType = parameters[0];
        }
        Set<PsiClassType> parameterTypes = EndpointPsiElementVisitor.createParameterTypes(project);
        for (PsiClassType aClassType : parameterTypes) {
            if (!aClassType.isAssignableFrom(baseType)) continue;
            return true;
        }
        return false;
    }

    public boolean isInjectedParameter(PsiType psiType, Project project) {
        Set<PsiClassType> injectedClassTypes = EndpointPsiElementVisitor.createInjectedClassTypes(project);
        for (PsiClassType aClassType : injectedClassTypes) {
            if (!aClassType.isAssignableFrom(psiType)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntityParameter(PsiType psiType, Project project) {
        return !this.isApiParameter(psiType, project) && !this.isInjectedParameter(psiType, project);
    }
}

