/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;

public class MethodReturnTypeInspection
extends EndpointInspectionBase {
    public String getStaticDescription() {
        return EndpointBundle.message("method.return.type.description", new Object[0]);
    }

    public String getDisplayName() {
        return EndpointBundle.message("method.return.type.name", new Object[0]);
    }

    public String getShortName() {
        return EndpointBundle.message("method.return.type.short.name", new Object[0]);
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitMethod(PsiMethod method) {
                Project project;
                if (!EndpointUtilities.isEndpointClass((PsiElement)method)) {
                    return;
                }
                if (this.hasTransformer((PsiElement)method)) {
                    return;
                }
                if (!EndpointUtilities.isApiMethod(method)) {
                    return;
                }
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return;
                }
                if (returnType.isAssignableFrom((PsiType)PsiType.VOID)) {
                    return;
                }
                try {
                    project = method.getContainingFile().getProject();
                    if (project == null) {
                        return;
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    EndpointInspectionBase.LOG.error("Error getting project with method " + method.getText(), (Throwable)e);
                    return;
                }
                if (!this.isEntityParameter(returnType, project)) {
                    holder.registerProblem((PsiElement)method.getReturnTypeElement(), "Invalid return type: " + returnType.getPresentableText() + ". Primitives and enums are not allowed.", LocalQuickFix.EMPTY_ARRAY);
                }
            }
        };
    }
}

