/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;

public class ResourceParameterInspection
extends EndpointInspectionBase {
    public String getStaticDescription() {
        return EndpointBundle.message("resource.parameter.description", new Object[0]);
    }

    public String getDisplayName() {
        return EndpointBundle.message("resource.parameter.name", new Object[0]);
    }

    public String getShortName() {
        return EndpointBundle.message("resource.parameter.short.name", new Object[0]);
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){
            private int resourceParameterCount = 0;

            public void visitMethod(PsiMethod method) {
                Project project;
                if (!EndpointUtilities.isEndpointClass((PsiElement)method)) {
                    return;
                }
                if (method.isConstructor()) {
                    return;
                }
                if (!EndpointUtilities.isApiMethod(method)) {
                    return;
                }
                try {
                    project = method.getContainingFile().getProject();
                    if (project == null) {
                        return;
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    EndpointInspectionBase.LOG.error("Error getting project with parameter " + method.getText(), (Throwable)e);
                    return;
                }
                this.resourceParameterCount = 0;
                for (PsiParameter aParameter : method.getParameterList().getParameters()) {
                    this.validateMethodParameters(aParameter, project);
                }
                if (this.resourceParameterCount > 1) {
                    holder.registerProblem((PsiElement)method, "Multiple entity parameters. There can only be a single entity parameter per method.", LocalQuickFix.EMPTY_ARRAY);
                }
            }

            private void validateMethodParameters(PsiParameter psiParameter, Project project) {
                PsiModifierList modifierList;
                PsiAnnotation annotation;
                PsiType type = psiParameter.getType();
                if (!this.isEntityParameter(type, project)) {
                    return;
                }
                ++this.resourceParameterCount;
                PsiClassType collectionType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.util.Collection");
                if (type instanceof PsiArrayType || collectionType.isAssignableFrom(type)) {
                    holder.registerProblem((PsiElement)psiParameter, "Illegal parameter type ('" + psiParameter.getType().getPresentableText() + "'). Arrays or collections of entity types are not allowed.", LocalQuickFix.EMPTY_ARRAY);
                }
                if ((annotation = (modifierList = psiParameter.getModifierList()).findAnnotation("javax.inject.Named")) == null && (annotation = modifierList.findAnnotation("com.google.api.server.spi.config.Named")) == null) {
                    return;
                }
                holder.registerProblem((PsiElement)psiParameter, "Bad parameter name. Parameter is entity (resource) type and should not be named.", LocalQuickFix.EMPTY_ARRAY);
            }
        };
    }
}

