/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.model.StackFrame;
import com.google.api.services.debugger.model.Variable;
import com.google.gct.idea.debugger.JavaUtil;
import com.google.gct.idea.util.GctBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import java.util.List;

public class CloudStackFrame
extends XStackFrame {
    private final List<Variable> myEvaluatedExpressions;
    private final StackFrame myFrame;
    private final List<Variable> myVariableTable;
    private final XSourcePosition myXSourcePosition;

    public CloudStackFrame(Project project, StackFrame frame, List<Variable> variableTable, List<Variable> evaluatedExpressions) {
        this.myFrame = frame;
        this.myVariableTable = variableTable;
        this.myEvaluatedExpressions = evaluatedExpressions;
        JavaUtil.initializeLocations(project, false);
        VirtualFile file = JavaUtil.getFileFromCloudPath(project, frame.getLocation().getPath());
        this.myXSourcePosition = XDebuggerUtil.getInstance().createPosition(file, frame.getLocation().getLine() - 1);
    }

    public void computeChildren(XCompositeNode node) {
        List locals;
        XValueChildrenList list = new XValueChildrenList();
        List arguments = this.myFrame.getArguments();
        if (arguments != null && arguments.size() > 0) {
            for (Variable variable : arguments) {
                if (Strings.isNullOrEmpty((String)variable.getName())) continue;
                list.add(variable.getName(), (XValue)new MyValue(variable, this.myVariableTable));
            }
        }
        if ((locals = this.myFrame.getLocals()) != null && locals.size() > 0) {
            for (Variable variable : locals) {
                if (Strings.isNullOrEmpty((String)variable.getName())) continue;
                list.add(variable.getName(), (XValue)new MyValue(variable, this.myVariableTable));
            }
        }
        if (this.myEvaluatedExpressions != null && this.myEvaluatedExpressions.size() > 0) {
            list.addTopGroup((XValueGroup)new CustomWatchGroup());
        }
        node.addChildren(list, true);
    }

    public void customizePresentation(ColoredTextContainer component) {
        component.setIcon(AllIcons.Debugger.StackFrame);
        String functionName = this.myFrame.getFunction();
        String className = "";
        String packageName = "";
        int lastDot = this.myFrame.getFunction().lastIndexOf(46);
        if (lastDot > 0 && lastDot < functionName.length() - 1) {
            functionName = functionName.substring(lastDot + 1);
            className = this.myFrame.getFunction().substring(0, lastDot);
            int classNameDot = className.lastIndexOf(46);
            if (classNameDot > 0 && classNameDot < className.length() - 1) {
                className = className.substring(classNameDot + 1);
                packageName = this.myFrame.getFunction().substring(0, classNameDot);
            }
        }
        component.append(functionName + "():" + this.myFrame.getLocation().getLine().toString() + ", " + className, this.myXSourcePosition != null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        component.append(" (" + packageName + ")", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
    }

    public Object getEqualityObject() {
        return CloudStackFrame.class;
    }

    public XDebuggerEvaluator getEvaluator() {
        return null;
    }

    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    private class CustomWatchGroup
    extends XValueGroup {
        protected CustomWatchGroup() {
            super(GctBundle.getString("clouddebug.watchexpressiongrouptitle", new Object[0]));
        }

        public void computeChildren(XCompositeNode node) {
            XValueChildrenList list = new XValueChildrenList();
            if (CloudStackFrame.this.myEvaluatedExpressions != null && CloudStackFrame.this.myEvaluatedExpressions.size() > 0) {
                for (Variable variable : CloudStackFrame.this.myEvaluatedExpressions) {
                    if (Strings.isNullOrEmpty((String)variable.getName())) continue;
                    list.add(variable.getName(), (XValue)new MyValue(variable, CloudStackFrame.this.myVariableTable));
                }
            }
            node.addChildren(list, true);
        }

        public boolean isAutoExpand() {
            return true;
        }
    }

    private static class MyValue
    extends XValue {
        private final List<Variable> myMembers;
        private final Variable myVariable;
        private final List<Variable> myVariableTable;

        public MyValue(Variable variable, List<Variable> variableTable) {
            this.myVariableTable = variableTable;
            this.myVariable = variable.getVarIndex() != null ? variableTable.get(variable.getVarIndex().intValue()) : variable;
            this.myMembers = this.myVariable.getMembers();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void computeChildren(XCompositeNode node) {
            XValueChildrenList list = new XValueChildrenList();
            if (this.myMembers != null && this.myMembers.size() > 0) {
                for (Variable variable : this.myMembers) {
                    if (Strings.isNullOrEmpty((String)variable.getName())) continue;
                    list.add(variable.getName(), (XValue)new MyValue(variable, this.myVariableTable));
                }
            }
            node.addChildren(list, true);
        }

        public void computePresentation(XValueNode node, XValuePlace place) {
            String value = this.myVariable.getValue();
            node.setPresentation(null, this.myMembers != null && this.myMembers.size() > 0 ? "..." : null, value != null ? value : "", this.myMembers != null && this.myMembers.size() > 0);
        }

        public String getEvaluationExpression() {
            return this.myVariable.getName();
        }
    }
}

