/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.Debugger;
import com.google.api.services.debugger.model.CloudRepoSourceContext;
import com.google.api.services.debugger.model.Debuggee;
import com.google.api.services.debugger.model.ListDebuggeesResponse;
import com.google.api.services.debugger.model.SourceContext;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebuggerClient;
import com.google.gct.idea.debugger.ProjectRepositoryState;
import com.google.gct.idea.util.GctBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.xmlb.annotations.Transient;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBrancher;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashUtils;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import git4idea.util.UntrackedFilesNotifier;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;

public class ProjectRepositoryValidator {
    private static final Logger LOG = Logger.getInstance(ProjectRepositoryValidator.class);
    private final CloudDebugProcessState myProcessState;
    private final ProjectRepositoryState myRepoState;
    private Debugger myCloudDebuggerClient;

    public ProjectRepositoryValidator(CloudDebugProcessState processState) {
        this.myProcessState = processState;
        this.myRepoState = ProjectRepositoryState.fromProcessState(processState);
    }

    @Transient
    public SyncResult checkSyncStashState() {
        if (this.myProcessState.getProject() == null) {
            return new SyncResult(true, false, false, true, null, null);
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)this.myProcessState.getProject());
        List repositories = manager.getRepositories();
        CloudRepoSourceContext cloudRepo = null;
        boolean foundDebuggee = false;
        if (this.getCloudDebuggerClient() != null && !com.google.common.base.Strings.isNullOrEmpty((String)this.myProcessState.getProjectNumber())) {
            try {
                ListDebuggeesResponse debuggees = (ListDebuggeesResponse)this.getCloudDebuggerClient().debuggees().list().setProject(this.myProcessState.getProjectNumber()).execute();
                for (Debuggee debuggee : debuggees.getDebuggees()) {
                    SourceContext sourceContext;
                    if (this.myProcessState.getDebuggeeId() == null || !this.myProcessState.getDebuggeeId().equals(debuggee.getId())) continue;
                    foundDebuggee = true;
                    List contexts = debuggee.getSourceContexts();
                    if (contexts == null) continue;
                    Iterator i$ = contexts.iterator();
                    while (i$.hasNext() && (cloudRepo = (sourceContext = (SourceContext)i$.next()).getCloudRepo()) == null) {
                    }
                }
            }
            catch (IOException ex) {
                LOG.warn("Error detecting server side source context", (Throwable)ex);
            }
        }
        if (!foundDebuggee) {
            return new SyncResult(true, false, false, true, null, null);
        }
        GitRepository targetLocalRepo = null;
        if (cloudRepo != null) {
            for (GitRepository repository : repositories) {
                try {
                    GitChangeUtils.resolveReference((Project)this.myProcessState.getProject(), (VirtualFile)repository.getRoot(), (String)cloudRepo.getRevisionId());
                    targetLocalRepo = repository;
                    break;
                }
                catch (VcsException ex) {
                    LOG.warn("cloud revision not found in local repo.  continuing search...");
                }
            }
        }
        boolean needsStash = false;
        boolean needsSync = false;
        String syncSHA = null;
        if (targetLocalRepo != null) {
            try {
                if (GitUtil.hasLocalChanges((boolean)true, (Project)this.myProcessState.getProject(), (VirtualFile)targetLocalRepo.getRoot()) || GitUtil.hasLocalChanges((boolean)false, (Project)this.myProcessState.getProject(), (VirtualFile)targetLocalRepo.getRoot())) {
                    needsStash = true;
                }
                if (!(Strings.isNullOrEmpty((String)targetLocalRepo.getCurrentRevision()) || Strings.isNullOrEmpty((String)cloudRepo.getRevisionId()) || targetLocalRepo.getCurrentRevision() == null || targetLocalRepo.getCurrentRevision().equals(cloudRepo.getRevisionId()))) {
                    syncSHA = cloudRepo.getRevisionId();
                    needsSync = true;
                }
            }
            catch (VcsException vcsException) {
                LOG.error("Error detecting local changes during attach", (Throwable)vcsException);
            }
        }
        return new SyncResult(false, needsStash, needsSync, targetLocalRepo != null, syncSHA, targetLocalRepo);
    }

    protected Debugger getCloudDebuggerClient() {
        if (this.myCloudDebuggerClient == null) {
            this.myCloudDebuggerClient = CloudDebuggerClient.getCloudDebuggerClient(this.myProcessState);
        }
        return this.myCloudDebuggerClient;
    }

    public void hardRefresh() {
        List list;
        if (this.myRepoState.hasSourceRepository() && !(list = VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.myRepoState.getSourceRepository().getRoot()})).isEmpty()) {
            LocalFileSystem.getInstance().refreshFiles((Iterable)list, false, true, null);
        }
    }

    @Transient
    public boolean isValidDebuggee() {
        SyncResult result = this.checkSyncStashState();
        return result.isValidDebuggee();
    }

    public void restoreToOriginalState(final Project project) {
        if (this.myRepoState.hasSourceRepository()) {
            assert (this.myRepoState.getSourceRepository() != null);
            final VirtualFile root = this.myRepoState.getSourceRepository().getRoot();
            final Ref targetStash = new Ref();
            if (!Strings.isNullOrEmpty((String)this.myRepoState.getStashMessage())) {
                GitStashUtils.loadStashStack((Project)project, (VirtualFile)root, (Consumer)new Consumer<StashInfo>(){

                    public void consume(StashInfo stashInfo) {
                        if (!Strings.isNullOrEmpty((String)stashInfo.getMessage()) && stashInfo.getMessage().equals(ProjectRepositoryValidator.this.myRepoState.getStashMessage())) {
                            targetStash.set((Object)stashInfo);
                        }
                    }
                });
            }
            if (!Strings.isNullOrEmpty((String)this.myRepoState.getOriginalBranchName())) {
                assert (this.myRepoState.getOriginalBranchName() != null);
                String branchDisplayName = this.myRepoState.getOriginalBranchName();
                if (branchDisplayName.length() > 10) {
                    branchDisplayName = branchDisplayName.substring(0, 7) + "...";
                }
                if (Messages.showYesNoDialog((String)GctBundle.getString("clouddebug.restorestash", branchDisplayName), (String)GctBundle.getString("clouddebug.restorechanges.title", new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
                    GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)project, GitBrancher.class);
                    brancher.checkout(this.myRepoState.getOriginalBranchName(), Collections.singletonList(this.myRepoState.getSourceRepository()), new Runnable(){

                        @Override
                        public void run() {
                            ProjectRepositoryValidator.this.myRepoState.getSourceRepository().update();
                            if (!targetStash.isNull()) {
                                ProjectRepositoryValidator.this.unstash(project, (Ref<StashInfo>)targetStash, root);
                            }
                        }
                    });
                }
            }
        }
    }

    private static void addStashParameter(Project project, GitHandler handler, String stash) {
        GitVcs vcs = GitVcs.getInstance((Project)project);
        if (vcs != null && GitVersionSpecialty.NEEDS_QUOTES_IN_STASH_NAME.existsIn(vcs.getVersion())) {
            handler.addParameters(new String[]{GeneralCommandLine.inescapableQuote((String)stash)});
        } else {
            handler.addParameters(new String[]{stash});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unstash(final Project project, final Ref<StashInfo> targetStash, final VirtualFile root) {
        if (this.myRepoState.getSourceRepository() == null || this.myRepoState.getOriginalBranchName() == null || !this.myRepoState.getOriginalBranchName().equals(this.myRepoState.getSourceRepository().getCurrentBranchName()) && !this.myRepoState.getOriginalBranchName().equals(this.myRepoState.getSourceRepository().getCurrentRevision())) {
            Messages.showErrorDialog((String)GctBundle.getString("clouddebug.erroroncheckout", this.myRepoState.getOriginalBranchName()), (String)"Error");
            return;
        }
        final GitLineHandler handler = new GitLineHandler(project, root, GitCommand.STASH);
        handler.addParameters(new String[]{"apply"});
        handler.addParameters(new String[]{"--index"});
        ProjectRepositoryValidator.addStashParameter(project, (GitHandler)handler, ((StashInfo)targetStash.get()).getStash());
        final AtomicBoolean conflict = new AtomicBoolean();
        handler.addLineListener((GitLineHandlerListener)new GitLineHandlerAdapter(){

            public void onLineAvailable(String line, Key outputType) {
                if (line.contains("Merge conflict")) {
                    conflict.set(true);
                }
            }
        });
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
        GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
        handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
        handler.addLineListener((GitLineHandlerListener)localChangesDetector);
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
        try {
            final Ref result = Ref.create();
            ProgressManager.getInstance().run((Task)new Task.Modal(handler.project(), GitBundle.getString((String)"unstash.unstashing"), false){

                public void run(ProgressIndicator indicator) {
                    indicator.setIndeterminate(true);
                    handler.addLineListener((GitLineHandlerListener)new GitHandlerUtil.GitLineHandlerListenerProgress(indicator, (GitHandler)handler, "stash", false));
                    Git git = (Git)ServiceManager.getService(Git.class);
                    result.set((Object)git.runCommand((Computable)new Computable.PredefinedValueComputable((Object)handler)));
                }
            });
            ((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)).hardRefresh(root);
            GitCommandResult res = (GitCommandResult)result.get();
            if (conflict.get()) {
                Messages.showDialog((String)GctBundle.getString("clouddebug.unstashmergeconflicts", new Object[0]), (String)"Merge Conflicts", (String[])new String[]{"Ok"}, (int)0, (Icon)Messages.getErrorIcon());
            } else if (untrackedFilesDetector.wasMessageDetected()) {
                UntrackedFilesNotifier.notifyUntrackedFilesOverwrittenBy((Project)project, (VirtualFile)root, (Collection)untrackedFilesDetector.getRelativeFilePaths(), (String)"unstash", null);
            } else if (localChangesDetector.wasMessageDetected()) {
                LocalChangesWouldBeOverwrittenHelper.showErrorDialog((Project)project, (VirtualFile)root, (String)"unstash", (Collection)localChangesDetector.getRelativeFilePaths());
            } else if (!res.success()) {
                GitUIUtil.showOperationErrors((Project)project, (Collection)handler.errors(), (String)handler.printableCommandLine());
            } else if (res.success()) {
                ProgressManager.getInstance().run((Task)new Task.Modal(project, GctBundle.getString("clouddebug.removestashx", ((StashInfo)targetStash.get()).getStash()), false){

                    public void run(ProgressIndicator indicator) {
                        if (this.myProject == null) {
                            return;
                        }
                        final GitSimpleHandler h = new GitSimpleHandler(this.myProject, root, GitCommand.STASH);
                        h.addParameters(new String[]{"drop"});
                        ProjectRepositoryValidator.addStashParameter(project, (GitHandler)h, ((StashInfo)targetStash.get()).getStash());
                        try {
                            h.run();
                            h.unsilence();
                        }
                        catch (VcsException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GitUIUtil.showOperationError((Project)myProject, (VcsException)ex, (String)h.printableCommandLine());
                                }
                            });
                        }
                    }
                });
            }
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)project, (AccessToken)token);
        }
    }

    public static class SyncResult {
        private final boolean myInvalidDebuggee;
        private final boolean myIsDeterminable;
        private final boolean myNeedsStash;
        private final boolean myNeedsSync;
        private final GitRepository myTargetRepository;
        private final String myTargetSyncSHA;

        private SyncResult(boolean invalidDebuggee, boolean needsStash, boolean needsSync, boolean isDeterminable, String targetSyncSHA, GitRepository targetRepository) {
            this.myInvalidDebuggee = invalidDebuggee;
            this.myNeedsStash = needsStash;
            this.myNeedsSync = needsSync;
            this.myIsDeterminable = isDeterminable;
            this.myTargetSyncSHA = targetSyncSHA;
            this.myTargetRepository = targetRepository;
        }

        public GitRepository getTargetRepository() {
            return this.myTargetRepository;
        }

        public String getTargetSyncSHA() {
            return this.myTargetSyncSHA;
        }

        public boolean isDeterminable() {
            return this.myIsDeterminable;
        }

        public boolean isValidDebuggee() {
            return !this.myInvalidDebuggee;
        }

        public boolean isValidSource() {
            return !this.myInvalidDebuggee && !this.myNeedsStash && !this.myNeedsSync;
        }

        public boolean needsStash() {
            return this.myNeedsStash;
        }

        public boolean needsSync() {
            return this.myNeedsSync;
        }
    }
}

