/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.git.CloneGcpDialog;
import com.google.gct.idea.git.GcpHttpAuthDataProvider;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class GcpCheckoutProvider
implements CheckoutProvider {
    private static final Logger LOG = Logger.getInstance(GcpCheckoutProvider.class);
    private final Git myGit;

    public GcpCheckoutProvider(Git git) {
        this.myGit = git;
    }

    public String getVcsName() {
        return "_Google Cloud";
    }

    public void doCheckout(Project project, CheckoutProvider.Listener listener) {
        File parent;
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "vcs", "checkout", null);
        BasicAction.saveAll();
        CloneGcpDialog dialog = new CloneGcpDialog(project);
        DialogManager.show((DialogWrapper)dialog);
        if (!dialog.isOK() || Strings.isNullOrEmpty((String)dialog.getParentDirectory()) || Strings.isNullOrEmpty((String)dialog.getSourceRepositoryURL()) || Strings.isNullOrEmpty((String)dialog.getDirectoryName())) {
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile destinationParent = lfs.findFileByIoFile(parent = new File(dialog.getParentDirectory()));
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        String gcpUserName = dialog.getGCPUserName();
        if (Strings.isNullOrEmpty((String)gcpUserName)) {
            LOG.error("unexpected blank username during checkout");
            return;
        }
        GcpCheckoutProvider.clone(project, this.myGit, listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory, gcpUserName);
    }

    private static void clone(final Project project, final Git git, final CheckoutProvider.Listener listener, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory, final String gcpUserName) {
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, GctBundle.message("clonefromgcp.repository", sourceRepositoryURL)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                GcpHttpAuthDataProvider.Context context = GcpHttpAuthDataProvider.createContext(gcpUserName);
                try {
                    cloneResult.set(GcpCheckoutProvider.doClone(project, indicator, git, directoryName, parentDirectory, sourceRepositoryURL));
                }
                finally {
                    context.Close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                destinationParent.refresh(true, true, new Runnable(){

                    @Override
                    public void run() {
                        if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                            VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                            mgr.fileDirty(destinationParent);
                        }
                    }
                });
                ProjectManagerListener configWriter = new ProjectManagerListener(){

                    public void projectOpened(Project project) {
                        PropertiesComponent.getInstance((Project)project).setValue("com.google.gct.idea.git.username", gcpUserName == null ? "" : gcpUserName);
                    }

                    public boolean canCloseProject(Project project) {
                        return true;
                    }

                    public void projectClosed(Project project) {
                    }

                    public void projectClosing(Project project) {
                    }
                };
                ProjectManager.getInstance().addProjectManagerListener(configWriter);
                try {
                    if (listener != null) {
                        listener.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                        listener.checkoutCompleted();
                    }
                }
                finally {
                    ProjectManager.getInstance().removeProjectManagerListener(configWriter);
                }
            }
        }.queue();
    }

    private static boolean doClone(Project project, ProgressIndicator indicator, Git git, String directoryName, String parentDirectory, String sourceRepositoryURL) {
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator);
        GitCommandResult result = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, new GitLineHandlerListener[]{progressListener});
        if (result.success()) {
            return true;
        }
        VcsNotifier.getInstance((Project)project).notifyError(GctBundle.message("clonefromgcp.failed", new Object[0]), result.getErrorOutputAsHtmlString());
        return false;
    }
}

