/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.git.ChooseProjectDialog;
import com.google.gct.idea.git.GcpHttpAuthDataProvider;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.util.GitFileUtils;
import git4idea.util.GitUIUtil;
import icons.GoogleCloudToolsIcons;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class UploadSourceAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(UploadSourceAction.class);

    public UploadSourceAction() {
        super(GctBundle.message("uploadtogcp.text", new Object[0]), GctBundle.message("uploadtogcp.description", new Object[0]), GoogleCloudToolsIcons.CLOUD);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(AnActionEvent e) {
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "vcs", "upload", null);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed() || !UploadSourceAction.isGitSupported(project)) {
            return;
        }
        UploadSourceAction.uploadProjectToGoogleCloud(project, file);
    }

    private static void uploadProjectToGoogleCloud(final Project project, VirtualFile file) {
        BasicAction.saveAll();
        project.save();
        GitRepository gitRepository = UploadSourceAction.getGitRepository(project, file);
        final boolean gitDetected = gitRepository != null;
        final VirtualFile root = gitDetected ? gitRepository.getRoot() : project.getBaseDir();
        boolean externalRemoteDetected = false;
        if (gitDetected) {
            String gcpRemote = GcpHttpAuthDataProvider.findGCPRemoteUrl(gitRepository);
            if (gcpRemote != null) {
                Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.alreadyexists", new Object[0]), (String)"Google");
                return;
            }
            externalRemoteDetected = !gitRepository.getRemotes().isEmpty();
        }
        ChooseProjectDialog dialog = new ChooseProjectDialog(project, GctBundle.message("uploadtogcp.selecttext", new Object[0]), GctBundle.message("uploadtogcp.oktext", new Object[0]));
        DialogManager.show((DialogWrapper)dialog);
        if (!dialog.isOK() || dialog.getCredentialedUser() == null || Strings.isNullOrEmpty((String)dialog.getProjectId())) {
            return;
        }
        final String projectId = dialog.getProjectId();
        final CredentialedUser user = dialog.getCredentialedUser();
        final boolean finalExternalRemoteDetected = externalRemoteDetected;
        new Task.Backgroundable(project, GctBundle.message("uploadtogcp.backgroundtitle", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                LOG.info("Binding local project with Git");
                if (!gitDetected) {
                    LOG.info("No git detected, creating empty git repo");
                    indicator.setText(GctBundle.message("uploadtogcp.indicatorinit", new Object[0]));
                    if (!UploadSourceAction.createEmptyGitRepository(project, root, indicator)) {
                        return;
                    }
                }
                GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)project);
                GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(root);
                LOG.assertTrue(repository != null, (Object)("GitRepository is null for root " + root));
                if (repository == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.failedtocreategit", new Object[0]), (String)"Google");
                        }
                    });
                    return;
                }
                String remoteUrl = GcpHttpAuthDataProvider.getGcpUrl(projectId);
                String remoteName = finalExternalRemoteDetected ? "cloud-platform" : "origin";
                LOG.info("Adding Google as a remote host");
                indicator.setText(GctBundle.message("uploadtogcp.addingremote", new Object[0]));
                if (!UploadSourceAction.addGitRemote(project, repository, remoteName, remoteUrl)) {
                    return;
                }
                boolean succeeded = false;
                try {
                    PropertiesComponent.getInstance((Project)project).setValue("com.google.gct.idea.git.username", user.getEmail());
                    LOG.info("Fetching from Google remote");
                    indicator.setText(GctBundle.message("uploadtogcp.fetching", new Object[0]));
                    if (!UploadSourceAction.fetchGit(project, indicator, repository, remoteName) || UploadSourceAction.hasRemoteBranch(project, repository, remoteName, projectId)) {
                        return;
                    }
                    if (!UploadSourceAction.performFirstCommitIfRequired(project, root, repository, indicator)) {
                        return;
                    }
                    LOG.info("Pushing to Google master");
                    indicator.setText(GctBundle.message("uploadtogcp.pushingtotgcp", new Object[0]));
                    if (!UploadSourceAction.pushCurrentBranch(project, repository, remoteName, remoteUrl)) {
                        return;
                    }
                    succeeded = true;
                }
                finally {
                    if (!succeeded) {
                        UploadSourceAction.removeGitRemote(project, repository, remoteName);
                    }
                }
                UploadSourceAction.showInfoURL(project, remoteName, GctBundle.message("uploadtogcp.success", new Object[0]), remoteUrl);
            }
        }.queue();
    }

    static void showInfoURL(Project project, String title, String message, String url) {
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, "<a href='" + url + "'>" + message + "</a>", NotificationListener.URL_OPENING_LISTENER);
    }

    private static GitRepository getGitRepository(Project project, VirtualFile file) {
        GitRepository repository;
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        List repositories = manager.getRepositories();
        if (repositories.size() == 0) {
            return null;
        }
        if (repositories.size() == 1) {
            return (GitRepository)repositories.get(0);
        }
        if (file != null && (repository = (GitRepository)manager.getRepositoryForFile(file)) != null) {
            return repository;
        }
        return (GitRepository)manager.getRepositoryForFile(project.getBaseDir());
    }

    private static boolean isGitSupported(Project project) {
        GitVersion version;
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        String executable = settings.getPathToGit();
        try {
            version = GitVersion.identifyVersion((String)executable);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.giterror", new Object[0]), (String)e.getMessage());
            return false;
        }
        if (!version.isSupported()) {
            Messages.showWarningDialog((Project)project, (String)GctBundle.message("uploadtogcp.git.unsupported.message", version.toString(), GitVersion.MIN), (String)GctBundle.message("uploadtogcp.giterror", new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean createEmptyGitRepository(final Project project, VirtualFile root, ProgressIndicator indicator) {
        GitLineHandler gitLineHandler = new GitLineHandler(project, root, GitCommand.INIT);
        gitLineHandler.setStdoutSuppressed(false);
        GitHandlerUtil.runInCurrentThread((GitHandler)gitLineHandler, (ProgressIndicator)indicator, (boolean)true, (String)GitBundle.getString((String)"initializing.title"));
        if (!gitLineHandler.errors().isEmpty()) {
            GitUIUtil.showOperationErrors((Project)project, (Collection)gitLineHandler.errors(), (String)"git init");
            LOG.info("Failed to create empty git repo: " + gitLineHandler.errors());
            return false;
        }
        try {
            GitConfigUtil.setValue((Project)project, (VirtualFile)root, (String)"credential.https://source.developers.google.com.useHttpPath", (String)"true", (String[])new String[0]);
        }
        catch (VcsException ex) {
            LOG.error("VcsException while setting up credential parameters (credentials will be not be cached per project url)" + ex.toString());
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    project.save();
                }
            });
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOG.error("InterruptedException while saving project: " + ex.toString());
            return false;
        }
        catch (InvocationTargetException ex) {
            LOG.error("InvocationTargetException while saving project: " + ex.toString());
            return false;
        }
        return true;
    }

    private static boolean fetchGit(final Project project, ProgressIndicator indicator, GitRepository repository, final String remote) {
        GitFetcher fetcher = new GitFetcher(project, indicator, true);
        GitFetchResult result = fetcher.fetch(repository);
        if (!result.isSuccess()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.fetchfailed", remote), (String)GctBundle.message("uploadtogcp.fetchfailedtitle", new Object[0]));
                }
            });
            return false;
        }
        repository.update();
        return true;
    }

    private static boolean hasRemoteBranch(final Project project, GitRepository repository, String remoteName, final String projectId) {
        for (GitRemoteBranch remoteBranch : repository.getInfo().getRemoteBranches()) {
            if (!remoteBranch.getRemote().getName().equalsIgnoreCase(remoteName)) continue;
            LOG.warn("git repo is not empty, bailing");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.remotenotempty", projectId), (String)GctBundle.message("uploadtogcp.remotenotemptytitle", new Object[0]));
                }
            });
            return true;
        }
        return false;
    }

    private static boolean addGitRemote(final Project project, GitRepository repository, String remote, final String url) {
        final GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"add", remote, url});
            handler.run();
            if (handler.getExitCode() != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.addremotefailed", url, handler.getStderr()), (String)GctBundle.message("uploadtogcp.addremotefailedtitle", new Object[0]));
                    }
                });
                return false;
            }
            repository.update();
            return true;
        }
        catch (VcsException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.addremotefailed", url, e.toString()), (String)GctBundle.message("uploadtogcp.addremotefailedtitle", new Object[0]));
                }
            });
            return false;
        }
    }

    private static void removeGitRemote(Project project, GitRepository repository, String remote) {
        GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"remove", remote});
            handler.run();
        }
        catch (VcsException e) {
            LOG.error("error removing newly added remote on error:" + e.toString());
        }
        repository.update();
    }

    private static boolean performFirstCommitIfRequired(final Project project, VirtualFile root, GitRepository repository, ProgressIndicator indicator) {
        if (!repository.isFresh()) {
            return true;
        }
        LOG.info("Trying to commit");
        try {
            LOG.info("Adding files for commit");
            indicator.setText(GctBundle.getString("uploadsourceaction.addfiles", new Object[0]));
            final List trackedFiles = ChangeListManager.getInstance((Project)project).getAffectedFiles();
            Collection<VirtualFile> untrackedFiles = UploadSourceAction.filterOutIgnored(project, repository.getUntrackedFilesHolder().retrieveUntrackedFiles());
            trackedFiles.removeAll(untrackedFiles);
            final ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
            allFiles.addAll(trackedFiles);
            allFiles.addAll(untrackedFiles);
            final Ref dialogRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GCPUntrackedFilesDialog dialog = new GCPUntrackedFilesDialog(project, allFiles);
                    if (!trackedFiles.isEmpty()) {
                        dialog.setSelectedFiles(trackedFiles);
                    }
                    DialogManager.show((DialogWrapper)dialog);
                    dialogRef.set((Object)dialog);
                }
            }, indicator.getModalityState());
            GCPUntrackedFilesDialog dialog = (GCPUntrackedFilesDialog)((Object)dialogRef.get());
            Collection files2commit = dialog.getSelectedFiles();
            if (!dialog.isOK() || files2commit.isEmpty()) {
                LOG.warn("user canceled out of initial commit.  aborting...");
                return false;
            }
            Collection files2add = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
            Collection files2rm = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
            HashSet modified = new HashSet((Collection)trackedFiles);
            modified.addAll(files2commit);
            GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
            GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
            LOG.info("Performing commit");
            indicator.setText(GctBundle.getString("uploadsourceaction.performingcommit", new Object[0]));
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{"-m", dialog.getCommitMessage()});
            handler.endOptions();
            handler.run();
            VcsFileUtil.refreshFiles((Project)project, (Collection)modified);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.initialcommitfailed", e.toString()), (String)GctBundle.message("uploadtogcp.initialcommitfailedtitle", new Object[0]));
                }
            });
            return false;
        }
        LOG.info("Successfully created initial commit");
        return true;
    }

    private static Collection<VirtualFile> filterOutIgnored(Project project, Collection<VirtualFile> files) {
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        final FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)project);
        return ContainerUtil.filter(files, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return !changeListManager.isIgnoredFile(file) && !fileIndex.isExcludedFile(file);
            }
        });
    }

    private static boolean pushCurrentBranch(final Project project, GitRepository repository, String remoteName, String remoteUrl) {
        Git git = (Git)ServiceManager.getService(Git.class);
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.initialpushfailed", new Object[0]), (String)GctBundle.message("uploadtogcp.initialpushfailedtitle", new Object[0]));
                }
            });
            return false;
        }
        GitCommandResult result = git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
        if (!result.success()) {
            LOG.warn(result.getErrorOutputAsJoinedString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)GctBundle.message("uploadtogcp.initialpushfailed", new Object[0]), (String)GctBundle.message("uploadtogcp.initialpushfailedtitle", new Object[0]));
                }
            });
            return false;
        }
        return true;
    }

    private static class GCPUntrackedFilesDialog
    extends SelectFilesDialog
    implements TypeSafeDataProvider {
        private static final float SPLIT_PROPORTION = 0.7f;
        private final Project myProject;
        private CommitMessage myCommitMessagePanel;

        public GCPUntrackedFilesDialog(Project project, List<VirtualFile> untrackedFiles) {
            super(project, untrackedFiles, null, null, true, false, false);
            this.myProject = project;
            this.setTitle(GctBundle.getString("uploadsourceaction.addfilestitle", new Object[0]));
            this.init();
        }

        protected JComponent createNorthPanel() {
            return null;
        }

        protected JComponent createCenterPanel() {
            JComponent tree = super.createCenterPanel();
            this.myCommitMessagePanel = new CommitMessage(this.myProject);
            this.myCommitMessagePanel.setCommitMessage("Initial commit");
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree);
            splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
            splitter.setProportion(0.7f);
            return splitter;
        }

        public String getCommitMessage() {
            return this.myCommitMessagePanel.getComment();
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key == VcsDataKeys.COMMIT_MESSAGE_CONTROL) {
                sink.put(VcsDataKeys.COMMIT_MESSAGE_CONTROL, (Object)this.myCommitMessagePanel);
            }
        }

        protected String getDimensionServiceKey() {
            return "GCP.UntrackedFilesDialog";
        }
    }
}

