/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.settings;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;

public class ExportSettings {
    public static final String SETTINGS_JAR_MARKER = "IntelliJ IDEA Global Settings";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doExport(String path) {
        HashSet<Object> exportableComponents = new HashSet<Object>(Arrays.asList(ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class)));
        exportableComponents.addAll(ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class));
        if (exportableComponents.isEmpty()) {
            return;
        }
        HashSet exportFiles = new HashSet();
        for (ExportableComponent exportableComponent : exportableComponents) {
            ContainerUtil.addAll(exportFiles, (Object[])exportableComponent.getExportFiles());
        }
        ApplicationManager.getApplication().saveSettings();
        File saveFile = new File(path);
        try {
            int n;
            if (saveFile.exists() && (n = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.overwrite.settings.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)saveFile.getPath())}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
                return;
            }
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(saveFile));
            try {
                File configPath = new File(PathManager.getConfigPath());
                HashSet<String> writtenItemRelativePaths = new HashSet<String>();
                for (File file : exportFiles) {
                    String rPath = FileUtil.getRelativePath((File)configPath, (File)file);
                    assert (rPath != null);
                    String relativePath = FileUtil.toSystemIndependentName((String)rPath);
                    if (!file.exists()) continue;
                    ZipUtil.addFileOrDirRecursively((ZipOutputStream)jarOutputStream, (File)saveFile, (File)file, (String)relativePath, null, writtenItemRelativePaths);
                }
                ExportSettings.exportInstalledPlugins(saveFile, jarOutputStream, writtenItemRelativePaths);
                File magicFile = new File(FileUtil.getTempDirectory(), SETTINGS_JAR_MARKER);
                FileUtil.createIfDoesntExist((File)magicFile);
                magicFile.deleteOnExit();
                ZipUtil.addFileToZip((ZipOutputStream)jarOutputStream, (File)magicFile, (String)SETTINGS_JAR_MARKER, writtenItemRelativePaths, null);
            }
            finally {
                jarOutputStream.close();
            }
        }
        catch (IOException iOException) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.writing.settings", (Object[])new Object[]{iOException.toString()}), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }

    private static void exportInstalledPlugins(File saveFile, JarOutputStream output, HashSet<String> writtenItemRelativePaths) throws IOException {
        ArrayList<String> oldPlugins = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (descriptor.isBundled() || !descriptor.isEnabled()) continue;
            oldPlugins.add(descriptor.getPluginId().getIdString());
        }
        if (!oldPlugins.isEmpty()) {
            File tempFile = File.createTempFile("installed", "plugins");
            tempFile.deleteOnExit();
            PluginManagerCore.savePluginsList(oldPlugins, (boolean)false, (File)tempFile);
            ZipUtil.addDirToZipRecursively((ZipOutputStream)output, (File)saveFile, (File)tempFile, (String)"/installed.txt", null, writtenItemRelativePaths);
        }
    }
}

