/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collections;
import java.util.List;
import org.gradle.internal.BiAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiActionBackedModelAction<T>
implements ModelAction<T> {
    private final ModelReference<T> modelReference;
    private final ModelRuleDescriptor descriptor;
    private final List<ModelReference<?>> inputs;
    private final BiAction<? super T, ? super List<ModelView<?>>> initializer;

    public BiActionBackedModelAction(ModelReference<T> modelReference, ModelRuleDescriptor descriptor, List<ModelReference<?>> inputs, BiAction<? super T, ? super List<ModelView<?>>> initializer) {
        this.modelReference = modelReference;
        this.descriptor = descriptor;
        this.inputs = inputs;
        this.initializer = initializer;
    }

    public static <T> BiActionBackedModelAction<T> of(ModelReference<T> modelReference, ModelRuleDescriptor descriptor, List<ModelReference<?>> inputs, BiAction<? super T, ? super List<ModelView<?>>> initializer) {
        return new BiActionBackedModelAction<T>(modelReference, descriptor, inputs, initializer);
    }

    public static <T, I> BiActionBackedModelAction<T> single(ModelReference<T> modelReference, ModelRuleDescriptor descriptor, final ModelReference<I> input, final BiAction<? super T, ? super I> initializer) {
        return new BiActionBackedModelAction<T>(modelReference, descriptor, Collections.singletonList(input), new BiAction<T, List<ModelView<?>>>(){

            public void execute(T t, List<ModelView<?>> modelViews) {
                initializer.execute(t, ModelViews.assertType(modelViews.get(0), input.getType()).getInstance());
            }
        });
    }

    @Override
    public ModelReference<T> getSubject() {
        return this.modelReference;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public List<ModelReference<?>> getInputs() {
        return this.inputs;
    }

    @Override
    public void execute(MutableModelNode modelNode, T object, List<ModelView<?>> inputs) {
        this.initializer.execute(object, inputs);
    }
}

