/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingModelProjection
implements ModelProjection {
    private final Iterable<? extends ModelProjection> projections;

    public ChainingModelProjection(Iterable<? extends ModelProjection> projections) {
        this.projections = projections;
    }

    public <B> boolean canBeViewedAsWritable(final ModelType<B> type) {
        return CollectionUtils.any(this.projections, (Spec)new Spec<ModelProjection>(){

            public boolean isSatisfiedBy(ModelProjection projection) {
                return projection.canBeViewedAsWritable(type);
            }
        });
    }

    public <B> boolean canBeViewedAsReadOnly(final ModelType<B> type) {
        return CollectionUtils.any(this.projections, (Spec)new Spec<ModelProjection>(){

            public boolean isSatisfiedBy(ModelProjection projection) {
                return projection.canBeViewedAsReadOnly(type);
            }
        });
    }

    private Iterable<String> collectDescriptions(Transformer<Iterable<String>, ModelProjection> transformer) {
        return CollectionUtils.flattenCollections(String.class, (Object[])new Object[]{CollectionUtils.collect(this.projections, transformer)});
    }

    @Override
    public Iterable<String> getWritableTypeDescriptions() {
        return this.collectDescriptions(new Transformer<Iterable<String>, ModelProjection>(){

            public Iterable<String> transform(ModelProjection projection) {
                return projection.getWritableTypeDescriptions();
            }
        });
    }

    @Override
    public Iterable<String> getReadableTypeDescriptions() {
        return this.collectDescriptions(new Transformer<Iterable<String>, ModelProjection>(){

            public Iterable<String> transform(ModelProjection projection) {
                return projection.getReadableTypeDescriptions();
            }
        });
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asReadOnly(ModelType<T> type, MutableModelNode node, ModelRuleDescriptor ruleDescriptor) {
        for (ModelProjection modelProjection : this.projections) {
            ModelView<T> view = modelProjection.asReadOnly(type, node, ruleDescriptor);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asWritable(ModelType<T> type, MutableModelNode node, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> inputs) {
        for (ModelProjection modelProjection : this.projections) {
            ModelView<T> view = modelProjection.asWritable(type, node, ruleDescriptor, inputs);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainingModelProjection that = (ChainingModelProjection)o;
        return this.projections.equals(that.projections);
    }

    public int hashCode() {
        return this.projections.hashCode();
    }

    public String toString() {
        return "ChainingModelProjection{projections=" + this.projections + '}';
    }
}

