/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.internal.Cast;
import org.gradle.model.ModelViewClosedException;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class CollectionBuilderModelView<T>
implements ModelView<CollectionBuilder<T>> {
    private final ModelType<CollectionBuilder<T>> type;
    private final CollectionBuilder<T> instance;
    private final ModelRuleDescriptor ruleDescriptor;
    private final ModelPath path;
    private boolean closed;

    public CollectionBuilderModelView(ModelPath path, ModelType<CollectionBuilder<T>> type, CollectionBuilder<T> rawInstance, ModelRuleDescriptor ruleDescriptor) {
        this.path = path;
        this.type = type;
        this.ruleDescriptor = ruleDescriptor;
        this.instance = new Decorator<T>(rawInstance);
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ModelType<CollectionBuilder<T>> getType() {
        return this.type;
    }

    @Override
    public CollectionBuilder<T> getInstance() {
        return this.instance;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Decorator<I>
    extends GroovyObjectSupport
    implements CollectionBuilder<I> {
        private final CollectionBuilder<I> rawInstance;

        public Decorator(CollectionBuilder<I> rawInstance) {
            this.rawInstance = rawInstance;
        }

        public String toString() {
            return this.rawInstance.toString();
        }

        @Override
        public <S> CollectionBuilder<S> withType(Class<S> type) {
            return new Decorator<S>(this.rawInstance.withType(type));
        }

        @Override
        public int size() {
            return this.rawInstance.size();
        }

        @Override
        public boolean isEmpty() {
            return this.rawInstance.isEmpty();
        }

        @Override
        @Nullable
        public I get(String name) {
            return this.rawInstance.get(name);
        }

        @Override
        @Nullable
        public I get(Object name) {
            return this.rawInstance.get(name);
        }

        @Override
        public boolean containsKey(Object name) {
            return this.rawInstance.containsKey(name);
        }

        @Override
        public boolean containsValue(Object item) {
            return this.rawInstance.containsValue(item);
        }

        @Override
        public Set<String> keySet() {
            return this.rawInstance.keySet();
        }

        @Override
        public void create(String name) {
            this.assertNotClosed();
            this.rawInstance.create(name);
        }

        @Override
        public void create(String name, Action<? super I> configAction) {
            this.assertNotClosed();
            this.rawInstance.create(name, configAction);
        }

        @Override
        public <S extends I> void create(String name, Class<S> type) {
            this.assertNotClosed();
            this.rawInstance.create(name, type);
        }

        @Override
        public <S extends I> void create(String name, Class<S> type, Action<? super S> configAction) {
            this.assertNotClosed();
            this.rawInstance.create(name, type, configAction);
        }

        @Override
        public void named(String name, Action<? super I> configAction) {
            this.assertNotClosed();
            this.rawInstance.named(name, configAction);
        }

        @Override
        public void named(String name, Class<? extends RuleSource> ruleSource) {
            this.assertNotClosed();
            this.rawInstance.named(name, ruleSource);
        }

        @Override
        public void beforeEach(Action<? super I> configAction) {
            this.assertNotClosed();
            this.rawInstance.beforeEach(configAction);
        }

        @Override
        public <S> void beforeEach(Class<S> type, Action<? super S> configAction) {
            this.assertNotClosed();
            this.rawInstance.beforeEach(type, configAction);
        }

        @Override
        public void all(Action<? super I> configAction) {
            this.assertNotClosed();
            this.rawInstance.all(configAction);
        }

        @Override
        public <S> void withType(Class<S> type, Action<? super S> configAction) {
            this.assertNotClosed();
            this.rawInstance.withType(type, configAction);
        }

        @Override
        public <S> void withType(Class<S> type, Class<? extends RuleSource> rules) {
            this.rawInstance.withType(type, rules);
        }

        @Override
        public void afterEach(Action<? super I> configAction) {
            this.assertNotClosed();
            this.rawInstance.afterEach(configAction);
        }

        @Override
        public <S> void afterEach(Class<S> type, Action<? super S> configAction) {
            this.assertNotClosed();
            this.rawInstance.afterEach(type, configAction);
        }

        @Override
        public void create(String name, Closure<? super I> configAction) {
            this.create(name, (Action<? super I>)new ClosureBackedAction(configAction));
        }

        @Override
        public <S extends I> void create(String name, Class<S> type, Closure<? super S> configAction) {
            this.create(name, type, (Action<? super S>)new ClosureBackedAction(configAction));
        }

        @Override
        public void named(String name, Closure<? super I> configAction) {
            this.named(name, (Action<? super I>)new ClosureBackedAction(configAction));
        }

        @Override
        public void all(Closure<? super I> configAction) {
            this.all((Action<? super I>)new ClosureBackedAction(configAction));
        }

        @Override
        public <S> void withType(Class<S> type, Closure<? super S> configAction) {
            this.withType(type, (Action<? super S>)new ClosureBackedAction(configAction));
        }

        @Override
        public void beforeEach(Closure<? super I> configAction) {
            this.beforeEach((Action<? super I>)new ClosureBackedAction(configAction));
        }

        @Override
        public <S> void beforeEach(Class<S> type, Closure<? super S> configAction) {
            this.beforeEach(type, (Action<? super S>)new ClosureBackedAction(configAction));
        }

        @Override
        public void afterEach(Closure<? super I> configAction) {
            this.afterEach((Action<? super I>)new ClosureBackedAction(configAction));
        }

        @Override
        public <S> void afterEach(Class<S> type, Closure<? super S> configAction) {
            this.afterEach(type, (Action<? super S>)new ClosureBackedAction(configAction));
        }

        public Object getProperty(String property) {
            I element = this.rawInstance.get(property);
            if (element == null) {
                throw new MissingPropertyException(property, CollectionBuilder.class);
            }
            return element;
        }

        public Void methodMissing(String name, Object argsObj) {
            Object[] args = (Object[])argsObj;
            if (args.length == 1 && args[0] instanceof Class) {
                Class itemType = (Class)Cast.uncheckedCast((Object)args[0]);
                this.create(name, itemType);
            } else if (args.length == 2 && args[0] instanceof Class && args[1] instanceof Closure) {
                Class itemType = (Class)Cast.uncheckedCast((Object)args[0]);
                Closure closure = (Closure)Cast.uncheckedCast((Object)args[1]);
                this.create(name, itemType, closure);
            } else if (args.length == 1 && args[0] instanceof Closure) {
                Closure closure = (Closure)Cast.uncheckedCast((Object)args[0]);
                this.named(name, closure);
            } else {
                throw new MissingMethodException(name, CollectionBuilder.class, args);
            }
            return null;
        }

        private void assertNotClosed() {
            if (CollectionBuilderModelView.this.closed) {
                throw new ModelViewClosedException(CollectionBuilderModelView.this.type, CollectionBuilderModelView.this.ruleDescriptor);
            }
        }
    }
}

