/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.internal.Actions;
import org.gradle.internal.BiAction;
import org.gradle.internal.Cast;
import org.gradle.internal.util.BiFunction;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.ActionBackedModelAction;
import org.gradle.model.internal.core.BiActionBackedModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultCollectionBuilder<T>
implements CollectionBuilder<T> {
    private final ModelType<T> elementType;
    private final ModelRuleDescriptor sourceDescriptor;
    private final MutableModelNode modelNode;
    private final BiFunction<? extends ModelCreators.Builder, ? super ModelPath, ? super ModelType<? extends T>> creatorFunction;

    public DefaultCollectionBuilder(ModelType<T> elementType, ModelRuleDescriptor sourceDescriptor, MutableModelNode modelNode, BiFunction<? extends ModelCreators.Builder, ? super ModelPath, ? super ModelType<? extends T>> creatorFunction) {
        this.elementType = elementType;
        this.sourceDescriptor = sourceDescriptor;
        this.modelNode = modelNode;
        this.creatorFunction = creatorFunction;
    }

    public String toString() {
        return this.modelNode.getPrivateData().toString();
    }

    @Override
    public int size() {
        return this.modelNode.getLinkCount(this.elementType);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public <S> CollectionBuilder<S> withType(Class<S> type) {
        if (type.equals(this.elementType.getConcreteClass())) {
            return (CollectionBuilder)Cast.uncheckedCast((Object)this);
        }
        if (this.elementType.getConcreteClass().isAssignableFrom(type)) {
            Class castType = (Class)Cast.uncheckedCast(type);
            CollectionBuilder<S> subType = this.toSubType(castType);
            return (CollectionBuilder)Cast.uncheckedCast(subType);
        }
        return new DefaultCollectionBuilder<S>(ModelType.of(type), this.sourceDescriptor, this.modelNode, new BiFunction<ModelCreators.Builder, ModelPath, ModelType<? extends S>>(){

            public ModelCreators.Builder apply(ModelPath s, ModelType<? extends S> modelType) {
                throw new IllegalArgumentException(String.format("Cannot create an item of type %s as this is not a subtype of %s.", modelType, DefaultCollectionBuilder.this.elementType.toString()));
            }
        });
    }

    public <S extends T> CollectionBuilder<S> toSubType(Class<S> type) {
        return new DefaultCollectionBuilder<S>(ModelType.of(type), this.sourceDescriptor, this.modelNode, this.creatorFunction);
    }

    @Override
    @Nullable
    public T get(Object name) {
        return this.get((String)name);
    }

    @Override
    @Nullable
    public T get(String name) {
        MutableModelNode link = this.modelNode.getLink(name);
        if (link == null) {
            return null;
        }
        link.ensureUsable();
        return link.asWritable(this.elementType, this.sourceDescriptor, null).getInstance();
    }

    @Override
    public boolean containsKey(Object name) {
        return name instanceof String && this.modelNode.hasLink((String)name, this.elementType);
    }

    @Override
    public Set<String> keySet() {
        return this.modelNode.getLinkNames(this.elementType);
    }

    @Override
    public boolean containsValue(Object item) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void create(String name) {
        this.doCreate(name, this.elementType);
    }

    @Override
    public void create(String name, Action<? super T> configAction) {
        this.doCreate(name, this.elementType, configAction);
    }

    @Override
    public <S extends T> void create(String name, Class<S> type) {
        this.doCreate(name, ModelType.of(type));
    }

    @Override
    public <S extends T> void create(String name, Class<S> type, Action<? super S> configAction) {
        this.doCreate(name, ModelType.of(type), configAction);
    }

    private <S extends T> void doCreate(String name, ModelType<S> type) {
        this.doCreate(name, type, Actions.doNothing());
    }

    private <S extends T> void doCreate(String name, ModelType<S> type, final Action<? super S> initAction) {
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "create(%s)", name);
        ModelCreators.Builder creatorBuilder = (ModelCreators.Builder)this.creatorFunction.apply((Object)this.modelNode.getPath().child(name), type);
        ModelCreator creator = creatorBuilder.withProjection(new UnmanagedModelProjection<S>(type, true, true)).descriptor(descriptor).build();
        this.modelNode.addLink(creator);
        this.modelNode.applyToLink(ModelActionRole.Initialize, new ActionBackedModelAction<S>(ModelReference.of(creator.getPath(), type), descriptor, new Action<S>(){

            public void execute(S s) {
                initAction.execute(s);
            }
        }));
        this.onCreate(name, type);
    }

    protected <S extends T> void onCreate(String name, ModelType<S> type) {
    }

    @Override
    public void named(String name, Action<? super T> configAction) {
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "named(%s)", name);
        ModelReference<T> subject = ModelReference.of(this.modelNode.getPath().child(name), this.elementType);
        this.modelNode.applyToLink(ModelActionRole.Mutate, new ActionBackedModelAction<T>(subject, descriptor, configAction));
    }

    @Override
    public void named(String name, Class<? extends RuleSource> ruleSource) {
        this.modelNode.applyToLink(name, ruleSource);
    }

    @Override
    public void all(Action<? super T> configAction) {
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "all()");
        ModelReference<T> subject = ModelReference.of(this.elementType);
        this.modelNode.applyToAllLinks(ModelActionRole.Mutate, new ActionBackedModelAction<T>(subject, descriptor, configAction));
    }

    @Override
    public <S> void withType(Class<S> type, Action<? super S> configAction) {
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "withType()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Mutate, new ActionBackedModelAction<S>(subject, descriptor, configAction));
    }

    @Override
    public <S> void withType(Class<S> type, Class<? extends RuleSource> rules) {
        this.modelNode.applyToLinks(type, rules);
    }

    @Override
    public void beforeEach(Action<? super T> configAction) {
        this.doBeforeEach(this.elementType, configAction);
    }

    @Override
    public <S> void beforeEach(Class<S> type, Action<? super S> configAction) {
        this.doBeforeEach(ModelType.of(type), configAction);
    }

    private <S> void doBeforeEach(ModelType<S> type, Action<? super S> configAction) {
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "beforeEach()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Defaults, new ActionBackedModelAction<S>(subject, descriptor, configAction));
    }

    @Override
    public void afterEach(Action<? super T> configAction) {
        this.doFinalizeAll(this.elementType, configAction);
    }

    @Override
    public <S> void afterEach(Class<S> type, Action<? super S> configAction) {
        this.doFinalizeAll(ModelType.of(type), configAction);
    }

    private <S> void doFinalizeAll(ModelType<S> type, Action<? super S> configAction) {
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "afterEach()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Finalize, new ActionBackedModelAction<S>(subject, descriptor, configAction));
    }

    public static <I> ModelType<CollectionBuilder<I>> typeOf(ModelType<I> type) {
        return new ModelType.Builder<CollectionBuilder<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    public static <I> ModelType<CollectionBuilder<I>> typeOf(Class<I> type) {
        return DefaultCollectionBuilder.typeOf(ModelType.of(type));
    }

    public static <I> ModelType<NamedEntityInstantiator<I>> instantiatorTypeOf(Class<I> type) {
        return DefaultCollectionBuilder.instantiatorTypeOf(ModelType.of(type));
    }

    public static <I> ModelType<NamedEntityInstantiator<I>> instantiatorTypeOf(ModelType<I> type) {
        return new ModelType.Builder<NamedEntityInstantiator<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    public static <T> BiFunction<ModelCreators.Builder, ModelPath, ModelType<? extends T>> createAndStoreVia(final ModelReference<? extends NamedEntityInstantiator<? super T>> instantiatorReference, final ModelReference<? extends Collection<? super T>> storeReference) {
        return new BiFunction<ModelCreators.Builder, ModelPath, ModelType<? extends T>>(){

            public ModelCreators.Builder apply(final ModelPath path, final ModelType<? extends T> modelType) {
                return ModelCreators.of(ModelReference.of(path, modelType), new BiAction<MutableModelNode, List<ModelView<?>>>(){

                    public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                        this.doExecute(modelNode, modelType, modelViews);
                    }

                    public <S extends T> void doExecute(MutableModelNode modelNode, ModelType<S> subType, List<ModelView<?>> modelViews) {
                        NamedEntityInstantiator instantiator = (NamedEntityInstantiator)ModelViews.getInstance(modelViews.get(0), instantiatorReference);
                        S item = instantiator.create(path.getName(), subType.getConcreteClass());
                        modelNode.setPrivateData(subType, item);
                        modelNode.applyToSelf(ModelActionRole.Initialize, BiActionBackedModelAction.single(ModelReference.of(path, subType), new SimpleModelRuleDescriptor("DefaultCollectionBuilder.createAndStoreVia() - " + path), storeReference, new BiAction<S, Collection<? super T>>(){

                            public void execute(S s, Collection<? super T> objects) {
                                objects.add(s);
                            }
                        }));
                    }
                }).inputs(instantiatorReference);
            }
        };
    }

    public static <T> BiFunction<ModelCreators.Builder, ModelPath, ModelType<? extends T>> createVia(final ModelReference<? extends NamedEntityInstantiator<? super T>> instantiatorReference) {
        return new BiFunction<ModelCreators.Builder, ModelPath, ModelType<? extends T>>(){

            public ModelCreators.Builder apply(final ModelPath path, final ModelType<? extends T> modelType) {
                return ModelCreators.of(ModelReference.of(path, modelType), new BiAction<MutableModelNode, List<ModelView<?>>>(){

                    public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                        this.doExecute(modelNode, modelType, modelViews);
                    }

                    public <S extends T> void doExecute(MutableModelNode modelNode, ModelType<S> subType, List<ModelView<?>> modelViews) {
                        NamedEntityInstantiator instantiator = (NamedEntityInstantiator)ModelViews.getInstance(modelViews.get(0), instantiatorReference);
                        S item = instantiator.create(path.getName(), subType.getConcreteClass());
                        modelNode.setPrivateData(subType, item);
                    }
                }).inputs(instantiatorReference);
            }
        };
    }
}

