/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.internal.BiAction;
import org.gradle.internal.Cast;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingCollectionBuilder<T>
implements CollectionBuilder<T> {
    private final CollectionBuilder<T> delegate;
    private final ModelType<T> baseType;
    private final BiAction<? super String, ? super ModelType<? extends T>> onCreate;

    public DelegatingCollectionBuilder(CollectionBuilder<T> delegate, ModelType<T> baseType, BiAction<? super String, ? super ModelType<? extends T>> onCreate) {
        this.delegate = delegate;
        this.baseType = baseType;
        this.onCreate = onCreate;
    }

    @Override
    public <S> CollectionBuilder<S> withType(Class<S> type) {
        BiAction castOnCreate = (BiAction)Cast.uncheckedCast(this.onCreate);
        return new DelegatingCollectionBuilder<S>(this.delegate.withType(type), ModelType.of(type), castOnCreate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    @Nullable
    public T get(Object name) {
        return this.delegate.get(name);
    }

    @Override
    @Nullable
    public T get(String name) {
        return this.delegate.get(name);
    }

    @Override
    public boolean containsKey(Object name) {
        return this.delegate.containsKey(name);
    }

    @Override
    public boolean containsValue(Object item) {
        return this.delegate.containsValue(item);
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public void create(String name) {
        this.delegate.create(name);
        this.onCreate(name, this.baseType);
    }

    @Override
    public void create(String name, Action<? super T> configAction) {
        this.delegate.create(name, configAction);
        this.onCreate(name, this.baseType);
    }

    @Override
    public <S extends T> void create(String name, Class<S> type) {
        this.delegate.create(name, type);
        this.onCreate(name, ModelType.of(type));
    }

    @Override
    public <S extends T> void create(String name, Class<S> type, Action<? super S> configAction) {
        this.onCreate(name, ModelType.of(type));
        this.delegate.create(name, type, configAction);
    }

    @Override
    public void named(String name, Action<? super T> configAction) {
        this.delegate.named(name, configAction);
    }

    @Override
    public void named(String name, Class<? extends RuleSource> ruleSource) {
        this.delegate.named(name, ruleSource);
    }

    @Override
    public void beforeEach(Action<? super T> configAction) {
        this.delegate.beforeEach(configAction);
    }

    @Override
    public <S> void beforeEach(Class<S> type, Action<? super S> configAction) {
        this.delegate.beforeEach(type, configAction);
    }

    @Override
    public void all(Action<? super T> configAction) {
        this.delegate.all(configAction);
    }

    @Override
    public <S> void withType(Class<S> type, Action<? super S> configAction) {
        this.delegate.withType(type, configAction);
    }

    @Override
    public <S> void withType(Class<S> type, Class<? extends RuleSource> rules) {
        this.delegate.withType(type, rules);
    }

    @Override
    public void afterEach(Action<? super T> configAction) {
        this.delegate.afterEach(configAction);
    }

    @Override
    public <S> void afterEach(Class<S> type, Action<? super S> configAction) {
        this.delegate.afterEach(type, configAction);
    }

    private <S extends T> void onCreate(String name, ModelType<S> type) {
        this.onCreate.execute((Object)name, type);
    }
}

