/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.BiAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectNodeModelAction<T>
implements ModelAction<T> {
    private final ModelReference<T> subjectReference;
    private final BiAction<? super MutableModelNode, ? super T> action;
    private final ModelRuleDescriptor descriptor;

    private DirectNodeModelAction(ModelReference<T> subjectReference, ModelRuleDescriptor descriptor, BiAction<? super MutableModelNode, ? super T> action) {
        this.subjectReference = subjectReference;
        this.action = action;
        this.descriptor = descriptor;
    }

    public static <T> ModelAction<T> of(ModelReference<T> reference, ModelRuleDescriptor descriptor, final Action<? super MutableModelNode> action) {
        return new DirectNodeModelAction<T>(reference, descriptor, new BiAction<MutableModelNode, T>(){

            public void execute(MutableModelNode modelNode, T t) {
                action.execute((Object)modelNode);
            }
        });
    }

    public static <T> ModelAction<T> of(ModelReference<T> reference, ModelRuleDescriptor descriptor, BiAction<? super MutableModelNode, ? super T> action) {
        return new DirectNodeModelAction<T>(reference, descriptor, action);
    }

    @Override
    public ModelReference<T> getSubject() {
        return this.subjectReference;
    }

    @Override
    public void execute(MutableModelNode modelNode, T object, List<ModelView<?>> inputs) {
        this.action.execute((Object)modelNode, object);
    }

    @Override
    public List<ModelReference<?>> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }
}

