/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.BiAction;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.model.internal.core.ChainingModelProjection;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.ProjectionBackedModelCreator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class ModelCreators {
    public static <T> Builder bridgedInstance(ModelReference<T> modelReference, T instance) {
        return ModelCreators.unmanagedInstance(modelReference, Factories.constant(instance));
    }

    public static <T> Builder unmanagedInstance(final ModelReference<T> modelReference, final Factory<? extends T> factory) {
        BiAction initializer = new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                modelNode.setPrivateData(modelReference.getType(), factory.create());
            }
        };
        return ModelCreators.of(modelReference, initializer).withProjection(new UnmanagedModelProjection<T>(modelReference.getType(), true, true));
    }

    public static Builder of(ModelReference<?> modelReference, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
        return new Builder(modelReference, initializer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static class Builder {
        private final BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer;
        private final ModelReference<?> modelReference;
        private final List<ModelProjection> projections = new ArrayList<ModelProjection>();
        private boolean ephemeral;
        private boolean hidden;
        private ModelRuleDescriptor modelRuleDescriptor;
        private List<? extends ModelReference<?>> inputs = Collections.emptyList();

        private Builder(ModelReference<?> modelReference, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
            this.modelReference = modelReference;
            this.initializer = initializer;
        }

        public Builder descriptor(String descriptor) {
            this.modelRuleDescriptor = new SimpleModelRuleDescriptor(descriptor);
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor descriptor) {
            this.modelRuleDescriptor = descriptor;
            return this;
        }

        public Builder inputs(List<? extends ModelReference<?>> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder inputs(ModelReference<?> ... inputs) {
            this.inputs = Arrays.asList(inputs);
            return this;
        }

        public Builder withProjection(ModelProjection projection) {
            this.projections.add(projection);
            return this;
        }

        public Builder hidden(boolean flag) {
            this.hidden = flag;
            return this;
        }

        public Builder ephemeral(boolean flag) {
            this.ephemeral = flag;
            return this;
        }

        public ModelCreator build() {
            ModelProjection projection = this.projections.size() == 1 ? this.projections.get(0) : new ChainingModelProjection(this.projections);
            return new ProjectionBackedModelCreator(this.modelReference.getPath(), this.modelRuleDescriptor, this.ephemeral, this.hidden, this.inputs, projection, this.initializer);
        }
    }
}

