/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.BiAction;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ProjectionBackedModelCreator
implements ModelCreator {
    private final ModelPath path;
    private final ModelRuleDescriptor descriptor;
    private final boolean ephemeral;
    private final boolean hidden;
    private final ModelProjection projection;
    private final List<? extends ModelReference<?>> inputs;
    private final BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer;

    public ProjectionBackedModelCreator(ModelPath path, ModelRuleDescriptor descriptor, boolean ephemeral, boolean hidden, List<? extends ModelReference<?>> inputs, ModelProjection projection, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
        this.path = path;
        this.descriptor = descriptor;
        this.ephemeral = ephemeral;
        this.hidden = hidden;
        this.projection = projection;
        this.inputs = inputs;
        this.initializer = initializer;
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ModelPromise getPromise() {
        return this.projection;
    }

    @Override
    public ModelAdapter getAdapter() {
        return this.projection;
    }

    @Override
    public void create(MutableModelNode node, List<ModelView<?>> inputs) {
        node.setHidden(this.hidden);
        this.initializer.execute((Object)node, inputs);
    }

    @Override
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    @Override
    public List<? extends ModelReference<?>> getInputs() {
        return this.inputs;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }
}

