/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.MethodDescription;
import org.gradle.model.internal.core.rule.describe.AbstractModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class MethodModelRuleDescriptor
extends AbstractModelRuleDescriptor {
    private final WeaklyTypeReferencingMethod<?, ?> method;
    private String description;

    public MethodModelRuleDescriptor(ModelType<?> target, ModelType<?> returnType, Method method) {
        this(WeaklyTypeReferencingMethod.of(target, returnType, method));
    }

    public MethodModelRuleDescriptor(WeaklyTypeReferencingMethod<?, ?> method) {
        this.method = method;
    }

    @Override
    public void describeTo(Appendable appendable) {
        try {
            appendable.append(this.getDescription());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private String getDescription() {
        if (this.description == null) {
            this.description = MethodDescription.name((String)this.method.getName()).owner(this.method.getDeclaringClass()).takes(this.method.getGenericParameterTypes()).toString();
        }
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodModelRuleDescriptor that = (MethodModelRuleDescriptor)o;
        return this.method.equals(that.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public static ModelRuleDescriptor of(Class<?> clazz, final String methodName) {
        List methodsOfName = CollectionUtils.filter((Object[])clazz.getDeclaredMethods(), (Spec)new Spec<Method>(){

            public boolean isSatisfiedBy(Method element) {
                return element.getName().equals(methodName);
            }
        });
        if (methodsOfName.isEmpty()) {
            throw new IllegalStateException("Class " + clazz.getName() + " has no method named '" + methodName + "'");
        }
        if (methodsOfName.size() > 1) {
            throw new IllegalStateException("Class " + clazz.getName() + " has more than one method named '" + methodName + "'");
        }
        Method method = (Method)methodsOfName.get(0);
        return MethodModelRuleDescriptor.of(clazz, method);
    }

    public static ModelRuleDescriptor of(Class<?> clazz, Method method) {
        return new MethodModelRuleDescriptor(ModelType.of(clazz), ModelType.returnType(method), method);
    }
}

