/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.internal.BiAction;
import org.gradle.model.internal.core.ActionBackedModelAction;
import org.gradle.model.internal.core.BiActionBackedModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreatorFactory;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ManagedModelInitializer;
import org.gradle.model.internal.inspect.ManagedSetInitializer;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.projection.ManagedSetModelProjection;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelStructSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelCreatorFactory
implements ModelCreatorFactory {
    private final ModelSchemaStore schemaStore;
    private final ManagedProxyFactory proxyFactory;

    public DefaultModelCreatorFactory(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
        this.proxyFactory = new ManagedProxyFactory();
    }

    @Override
    public <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelPath path, ModelSchema<T> schema) {
        ModelReference<T> modelReference = ModelReference.of(path, schema.getType());
        return this.creator(descriptor, modelReference, schema, null);
    }

    @Override
    public <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelPath path, ModelSchema<T> schema, Action<? super T> initializer) {
        ModelReference<T> modelReference = ModelReference.of(path, schema.getType());
        ActionBackedModelAction<? super T> modelAction = new ActionBackedModelAction<T>(modelReference, descriptor, initializer);
        return this.creator(descriptor, modelReference, schema, modelAction);
    }

    @Override
    public <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelPath path, ModelSchema<T> schema, List<ModelReference<?>> initializerInputs, BiAction<? super T, ? super List<ModelView<?>>> initializer) {
        ModelReference<T> modelReference = ModelReference.of(path, schema.getType());
        BiActionBackedModelAction<? super T> modelAction = new BiActionBackedModelAction<T>(modelReference, descriptor, initializerInputs, initializer);
        return this.creator(descriptor, modelReference, schema, modelAction);
    }

    private <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelReference<T> modelReference, ModelSchema<T> schema, @Nullable ModelAction<T> initializer) {
        if (schema instanceof ModelCollectionSchema) {
            ModelCollectionSchema collectionSchema = (ModelCollectionSchema)schema;
            ModelSchema<?> elementSchema = this.schemaStore.getSchema(collectionSchema.getElementType());
            return ModelCreators.of(modelReference, new ManagedSetInitializer<T>(initializer)).withProjection(ManagedSetModelProjection.of(elementSchema, this)).descriptor(descriptor).build();
        }
        if (schema instanceof ModelStructSchema) {
            ModelStructSchema structSchema = (ModelStructSchema)schema;
            return ModelCreators.of(modelReference, new ManagedModelInitializer<T>(descriptor, structSchema, this.schemaStore, this, initializer)).withProjection(new ManagedModelProjection(structSchema, this.schemaStore, this.proxyFactory)).descriptor(descriptor).build();
        }
        throw new IllegalArgumentException("Don't know how to create model element from schema for " + schema.getType());
    }
}

