/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.instance;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gradle.internal.UncheckedException;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ModelStructSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProxyFactory {
    public <T> T createProxy(ModelElementState state, ModelStructSchema<T> schema) {
        try {
            Class<T> generatedClass = schema.getManagedImpl();
            if (generatedClass == null) {
                throw new IllegalStateException("No managed implementation class available for: " + schema.getType());
            }
            Constructor<T> constructor = generatedClass.getConstructor(ModelElementState.class);
            return constructor.newInstance(state);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

