/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.projection;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.model.ModelViewClosedException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedModelProjection<M>
extends TypeCompatibilityModelProjectionSupport<M> {
    private final ModelSchemaStore schemaStore;
    private final ManagedProxyFactory proxyFactory;
    private final ModelStructSchema<M> schema;

    public ManagedModelProjection(ModelStructSchema<M> schema, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory) {
        super(schema.getType(), true, true);
        this.schema = schema;
        this.schemaStore = schemaStore;
        this.proxyFactory = proxyFactory;
    }

    @Override
    protected ModelView<M> toView(final MutableModelNode modelNode, final ModelRuleDescriptor ruleDescriptor, final boolean writable) {
        return new ModelView<M>(){
            private boolean closed;
            private final Map<String, Object> propertyViews = new HashMap<String, Object>();

            @Override
            public ModelPath getPath() {
                return modelNode.getPath();
            }

            @Override
            public ModelType<M> getType() {
                return ManagedModelProjection.this.getType();
            }

            @Override
            public M getInstance() {
                return ManagedModelProjection.this.proxyFactory.createProxy(new State(), ManagedModelProjection.this.schema);
            }

            @Override
            public void close() {
                this.closed = true;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class State
            implements ModelElementState {
                State() {
                }

                @Override
                public MutableModelNode getBackingNode() {
                    return modelNode;
                }

                @Override
                public String getDisplayName() {
                    return String.format("%s '%s'", this.getType(), modelNode.getPath().toString());
                }

                @Override
                public Object get(String name) {
                    if (propertyViews.containsKey(name)) {
                        return propertyViews.get(name);
                    }
                    ModelProperty property = (ModelProperty)ManagedModelProjection.this.schema.getProperties().get((Object)name);
                    Object value = this.doGet(property, name);
                    propertyViews.put(name, value);
                    return value;
                }

                private <T> T doGet(ModelProperty<T> property, String propertyName) {
                    ModelType<T> propertyType = property.getType();
                    ModelSchema<T> schema = ManagedModelProjection.this.schemaStore.getSchema(propertyType);
                    MutableModelNode propertyNode = modelNode.getLink(propertyName);
                    propertyNode.ensureUsable();
                    MutableModelNode targetNode = propertyNode;
                    if (property.isWritable() && schema.getKind().isManaged() && (targetNode = propertyNode.getTarget()) == null) {
                        return null;
                    }
                    if (writable) {
                        ModelView<T> modelView = targetNode.asWritable(propertyType, ruleDescriptor, null);
                        if (closed) {
                            modelView.close();
                        }
                        return modelView.getInstance();
                    }
                    return targetNode.asReadOnly(propertyType, ruleDescriptor).getInstance();
                }

                @Override
                public void set(String name, Object value) {
                    if (!writable || closed) {
                        throw new ModelViewClosedException(this.getType(), ruleDescriptor);
                    }
                    ModelProperty property = (ModelProperty)ManagedModelProjection.this.schema.getProperties().get((Object)name);
                    ModelType propertyType = property.getType();
                    this.doSet(name, value, propertyType);
                    propertyViews.put(name, value);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private <T> void doSet(String name, Object value, ModelType<T> propertyType) {
                    ModelSchema<T> schema = ManagedModelProjection.this.schemaStore.getSchema(propertyType);
                    MutableModelNode propertyNode = modelNode.getLink(name);
                    propertyNode.ensureUsable();
                    if (schema.getKind().isManaged()) {
                        if (value == null) {
                            propertyNode.setTarget(null);
                            return;
                        } else {
                            if (!ManagedInstance.class.isInstance(value)) throw new IllegalArgumentException(String.format("Only managed model instances can be set as property '%s' of class '%s'", name, this.getType()));
                            ManagedInstance managedInstance = (ManagedInstance)value;
                            MutableModelNode targetNode = managedInstance.getBackingNode();
                            propertyNode.setTarget(targetNode);
                        }
                        return;
                    } else {
                        Object castValue = Cast.uncheckedCast((Object)value);
                        propertyNode.setPrivateData(propertyType, castValue);
                    }
                }
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

