/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.projection;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.model.ModelViewClosedException;
import org.gradle.model.WriteOnlyModelViewException;
import org.gradle.model.collection.ManagedSet;
import org.gradle.model.internal.core.ActionBackedModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreatorFactory;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedSetModelProjection<I>
extends TypeCompatibilityModelProjectionSupport<ManagedSet<I>> {
    private final ModelCreatorFactory modelCreatorFactory;
    private final ModelSchema<I> elementSchema;

    private ManagedSetModelProjection(ModelSchema<I> elementSchema, ModelCreatorFactory modelCreatorFactory) {
        super(ManagedSetModelProjection.typeOf(elementSchema.getType()), true, true);
        this.elementSchema = elementSchema;
        this.modelCreatorFactory = modelCreatorFactory;
    }

    public static <I> ManagedSetModelProjection<I> of(ModelSchema<I> elementSchema, ModelCreatorFactory modelCreatorFactory) {
        return new ManagedSetModelProjection<I>(elementSchema, modelCreatorFactory);
    }

    public static <I> ModelType<ManagedSet<I>> typeOf(ModelType<I> elementType) {
        return new ModelType.Builder<ManagedSet<I>>(){}.where(new ModelType.Parameter<I>(){}, elementType).build();
    }

    @Override
    protected ModelView<ManagedSet<I>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
        return new ManagedSetModelView(this.getType(), this.elementSchema, modelNode, writable, ruleDescriptor, this.modelCreatorFactory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedSetModelView<I>
    implements ModelView<ManagedSet<I>> {
        private final ModelType<ManagedSet<I>> type;
        private final ModelSchema<I> elementSchema;
        private final MutableModelNode modelNode;
        private final boolean writable;
        private final ModelRuleDescriptor ruleDescriptor;
        private final ModelCreatorFactory modelCreatorFactory;
        private boolean closed;
        private Set<I> elementViews;
        private final ModelReference<I> elementReference;

        public ManagedSetModelView(ModelType<ManagedSet<I>> type, ModelSchema<I> elementSchema, MutableModelNode modelNode, boolean writable, ModelRuleDescriptor ruleDescriptor, ModelCreatorFactory modelCreatorFactory) {
            this.type = type;
            this.elementSchema = elementSchema;
            this.modelNode = modelNode;
            this.writable = writable;
            this.ruleDescriptor = ruleDescriptor;
            this.modelCreatorFactory = modelCreatorFactory;
            this.elementReference = ModelReference.of(elementSchema.getType());
        }

        @Override
        public ModelPath getPath() {
            return this.modelNode.getPath();
        }

        @Override
        public ModelType<ManagedSet<I>> getType() {
            return this.type;
        }

        @Override
        public ManagedSet<I> getInstance() {
            return new ModelNodeBackedManagedSet();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        private void ensureReadable() {
            if (this.writable && !this.closed) {
                throw new WriteOnlyModelViewException(this.getType(), this.ruleDescriptor);
            }
            if (this.elementViews == null) {
                this.elementViews = new LinkedHashSet<I>();
                for (MutableModelNode mutableModelNode : this.modelNode.getLinks(this.elementSchema.getType())) {
                    this.elementViews.add(mutableModelNode.asReadOnly(this.elementSchema.getType(), this.ruleDescriptor).getInstance());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ModelNodeBackedManagedSet
        implements ManagedSet<I>,
        ManagedInstance {
            @Override
            public MutableModelNode getBackingNode() {
                return ManagedSetModelView.this.modelNode;
            }

            public String toString() {
                return String.format("%s '%s'", ManagedSetModelView.this.getType(), ManagedSetModelView.this.modelNode.getPath().toString());
            }

            @Override
            public void create(Action<? super I> action) {
                this.assertMutable();
                String name = String.valueOf(ManagedSetModelView.this.modelNode.getLinkCount(ManagedSetModelView.this.elementSchema.getType()));
                ModelPath path = ManagedSetModelView.this.modelNode.getPath().child(name);
                ManagedSetModelView.this.modelNode.addLink(ManagedSetModelView.this.modelCreatorFactory.creator(ManagedSetModelView.this.ruleDescriptor, path, ManagedSetModelView.this.elementSchema, action));
            }

            public void assertMutable() {
                if (!ManagedSetModelView.this.writable || ManagedSetModelView.this.closed) {
                    throw new ModelViewClosedException(ManagedSetModelView.this.getType(), ManagedSetModelView.this.ruleDescriptor);
                }
            }

            @Override
            public void afterEach(Action<? super I> configAction) {
                this.assertMutable();
                ManagedSetModelView.this.modelNode.applyToAllLinks(ModelActionRole.Finalize, new ActionBackedModelAction(ManagedSetModelView.this.elementReference, NestedModelRuleDescriptor.append(ManagedSetModelView.this.ruleDescriptor, "afterEach()"), configAction));
            }

            @Override
            public void beforeEach(Action<? super I> configAction) {
                this.assertMutable();
                ManagedSetModelView.this.modelNode.applyToAllLinks(ModelActionRole.Defaults, new ActionBackedModelAction(ManagedSetModelView.this.elementReference, NestedModelRuleDescriptor.append(ManagedSetModelView.this.ruleDescriptor, "afterEach()"), configAction));
            }

            @Override
            public int size() {
                ManagedSetModelView.this.ensureReadable();
                return ManagedSetModelView.this.elementViews.size();
            }

            @Override
            public boolean isEmpty() {
                ManagedSetModelView.this.ensureReadable();
                return ManagedSetModelView.this.elementViews.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                ManagedSetModelView.this.ensureReadable();
                return ManagedSetModelView.this.elementViews.contains(o);
            }

            @Override
            public Iterator<I> iterator() {
                ManagedSetModelView.this.ensureReadable();
                return ManagedSetModelView.this.elementViews.iterator();
            }

            @Override
            public Object[] toArray() {
                ManagedSetModelView.this.ensureReadable();
                return ManagedSetModelView.this.elementViews.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                ManagedSetModelView.this.ensureReadable();
                return ManagedSetModelView.this.elementViews.toArray(a);
            }

            @Override
            public boolean add(I e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                ManagedSetModelView.this.ensureReadable();
                return ManagedSetModelView.this.elementViews.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends I> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void create(Closure<?> closure) {
                this.create((Action<? super I>)((Action)ClosureBackedAction.of(closure)));
            }

            @Override
            public void afterEach(Closure<?> closure) {
                this.afterEach((Action<? super I>)((Action)ClosureBackedAction.of(closure)));
            }

            @Override
            public void beforeEach(Closure<?> closure) {
                this.beforeEach((Action<? super I>)((Action)ClosureBackedAction.of(closure)));
            }
        }
    }
}

