/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import net.jcip.annotations.ThreadSafe;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelSchema<T> {
    private final ModelType<T> type;
    private final Kind kind;

    public static <T> ModelSchema<T> value(ModelType<T> type) {
        return new ModelSchema<T>(type, Kind.VALUE);
    }

    public static <T> ModelStructSchema<T> struct(ModelType<T> type, Iterable<ModelProperty<?>> properties, Class<? extends T> managedImpl) {
        return new ModelStructSchema<T>(type, properties, managedImpl);
    }

    public static <T> ModelCollectionSchema<T> collection(ModelType<T> type, ModelType<?> elementType) {
        return new ModelCollectionSchema<T>(type, elementType);
    }

    public static <T> ModelSchema<T> unmanaged(ModelType<T> type) {
        return new ModelSchema<T>(type, Kind.UNMANAGED);
    }

    protected ModelSchema(ModelType<T> type, Kind kind) {
        this.type = type;
        this.kind = kind;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public Kind getKind() {
        return this.kind;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        VALUE(false, true),
        COLLECTION,
        STRUCT,
        UNMANAGED(false, false);

        private final boolean isManaged;
        private final boolean isAllowedPropertyTypeOfManagedType;

        private Kind() {
            this(true, true);
        }

        private Kind(boolean isManaged, boolean isAllowedPropertyTypeOfManagedType) {
            this.isManaged = isManaged;
            this.isAllowedPropertyTypeOfManagedType = isAllowedPropertyTypeOfManagedType;
        }

        public boolean isManaged() {
            return this.isManaged;
        }

        public boolean isAllowedPropertyTypeOfManagedType() {
            return this.isAllowedPropertyTypeOfManagedType;
        }
    }
}

