/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Factory;
import org.gradle.internal.SystemProperties;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.EnumStrategy;
import org.gradle.model.internal.manage.schema.extract.JdkValueTypeStrategy;
import org.gradle.model.internal.manage.schema.extract.ManagedSetStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.PrimitiveStrategy;
import org.gradle.model.internal.manage.schema.extract.StructStrategy;
import org.gradle.model.internal.manage.schema.extract.UnmanagedStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class ModelSchemaExtractor {
    private final Factory<String> supportedTypeDescriptions = new Factory<String>(){

        public String create() {
            return ModelSchemaExtractor.this.getSupportedTypesDescription();
        }
    };
    private final List<ModelSchemaExtractionStrategy> strategies = ImmutableList.of((Object)new PrimitiveStrategy(), (Object)new EnumStrategy(), (Object)new JdkValueTypeStrategy(), (Object)new ManagedSetStrategy(this.supportedTypeDescriptions), (Object)new StructStrategy(this.supportedTypeDescriptions), (Object)new UnmanagedStrategy());

    ModelSchemaExtractor() {
    }

    public <T> ModelSchema<T> extract(ModelType<T> type, ModelSchemaCache cache) {
        ModelSchemaExtractionContext context = ModelSchemaExtractionContext.root(type);
        LinkedList validations = Lists.newLinkedList();
        LinkedList unsatisfiedDependencies = Lists.newLinkedList();
        ModelSchemaExtractionContext extractionContext = context;
        validations.add(extractionContext);
        while (extractionContext != null) {
            ModelSchemaExtractionResult<T> nextSchema = this.extractSchema(extractionContext, cache);
            Iterable<ModelSchemaExtractionContext<?>> dependencies = nextSchema.getDependencies();
            Iterables.addAll((Collection)validations, dependencies);
            this.pushUnsatisfiedDependencies(dependencies, unsatisfiedDependencies, cache);
            extractionContext = (ModelSchemaExtractionContext)unsatisfiedDependencies.poll();
        }
        for (ModelSchemaExtractionContext validationContext : Lists.reverse((List)validations)) {
            validationContext.validate();
        }
        return cache.get(context.getType());
    }

    private void pushUnsatisfiedDependencies(Iterable<? extends ModelSchemaExtractionContext<?>> allDependencies, Queue<ModelSchemaExtractionContext<?>> dependencyQueue, final ModelSchemaCache cache) {
        Iterables.addAll(dependencyQueue, (Iterable)Iterables.filter(allDependencies, (Predicate)new Predicate<ModelSchemaExtractionContext<?>>(){

            public boolean apply(ModelSchemaExtractionContext<?> dependency) {
                return cache.get(dependency.getType()) == null;
            }
        }));
    }

    private <T> ModelSchemaExtractionResult<T> extractSchema(ModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache) {
        ModelType<T> type = extractionContext.getType();
        ModelSchema<T> cached = cache.get(type);
        if (cached != null) {
            return new ModelSchemaExtractionResult<T>(cached);
        }
        for (ModelSchemaExtractionStrategy strategy : this.strategies) {
            ModelSchemaExtractionResult<T> result = strategy.extract(extractionContext, cache);
            if (result == null) continue;
            cache.set(type, result.getSchema());
            return result;
        }
        throw new IllegalStateException("No extraction strategy found for type: " + type);
    }

    private String getSupportedTypesDescription() {
        return Joiner.on((String)SystemProperties.getInstance().getLineSeparator()).join(Iterables.transform(this.getSupportedTypes(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return " - " + input;
            }
        }));
    }

    private Iterable<String> getSupportedTypes() {
        return Iterables.concat((Iterable)Iterables.transform(this.strategies, (Function)new Function<ModelSchemaExtractionStrategy, Iterable<String>>(){

            public Iterable<String> apply(ModelSchemaExtractionStrategy input) {
                return input.getSupportedManagedTypes();
            }
        }));
    }
}

