/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.internal.BiActions;
import org.gradle.internal.Cast;
import org.gradle.model.ConfigurationCycleException;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.DuplicateModelException;
import org.gradle.model.internal.core.EmptyModelProjection;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRule;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.registry.CreatorRuleBinder;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelCreationListener;
import org.gradle.model.internal.registry.ModelGraph;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.ModelPathSuggestionProvider;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.MutatorRuleBinder;
import org.gradle.model.internal.registry.OneOfTypeBinderCreationListener;
import org.gradle.model.internal.registry.PathBinderCreationListener;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.registry.UnboundModelRulesException;
import org.gradle.model.internal.registry.UnboundRulesProcessor;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultModelRegistry
implements ModelRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModelRegistry.class);
    private final ModelGraph modelGraph;
    private final ModelRuleExtractor ruleExtractor;
    private final Set<RuleBinder> binders = Sets.newIdentityHashSet();
    private final List<MutatorRuleBinder<?>> pendingMutatorBinders = Lists.newLinkedList();
    private final List<MutatorRuleBinder<?>> unboundSubjectMutatorBinders = Lists.newLinkedList();
    private final LinkedHashMap<ModelRule, ModelBinding<?>> rulesWithInputsBeingClosed = Maps.newLinkedHashMap();
    boolean reset;

    public DefaultModelRegistry(ModelRuleExtractor ruleExtractor) {
        this.ruleExtractor = ruleExtractor;
        ModelCreator rootCreator = ModelCreators.of(ModelReference.of(ModelPath.ROOT), BiActions.doNothing()).descriptor("<root>").withProjection(EmptyModelProjection.INSTANCE).build();
        this.modelGraph = new ModelGraph(new ModelElementNode(this.toCreatorBinder(rootCreator)));
        this.modelGraph.getRoot().setState(ModelNode.State.Created);
    }

    private static String toString(ModelRuleDescriptor descriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        descriptor.describeTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public DefaultModelRegistry create(ModelCreator creator) {
        ModelPath path = creator.getPath();
        if (!ModelPath.ROOT.isDirectChild(path)) {
            throw new InvalidModelRuleDeclarationException(creator.getDescriptor(), "Cannot create element at '" + path + "', only top level is allowed (e.g. '" + path.getRootParent() + "')");
        }
        this.registerNode(this.modelGraph.getRoot(), new ModelElementNode(this.toCreatorBinder(creator)));
        return this;
    }

    public CreatorRuleBinder toCreatorBinder(ModelCreator creator) {
        return new CreatorRuleBinder(creator, ModelPath.ROOT, this.binders);
    }

    private ModelNodeInternal registerNode(ModelNodeInternal parent, ModelNodeInternal child) {
        if (this.reset) {
            return child;
        }
        ModelCreator creator = child.getCreatorBinder().getCreator();
        ModelPath path = child.getPath();
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node != null) {
            if (node.getState() == ModelNode.State.Known) {
                throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' is already registered to create this model element.", path, DefaultModelRegistry.toString(creator.getDescriptor()), DefaultModelRegistry.toString(node.getDescriptor())));
            }
            throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' has already been used to create this model element.", path, DefaultModelRegistry.toString(creator.getDescriptor()), DefaultModelRegistry.toString(node.getDescriptor())));
        }
        if (!parent.isMutable()) {
            throw new IllegalStateException(String.format("Cannot create '%s' using creation rule '%s' as model element '%s' is no longer mutable.", path, DefaultModelRegistry.toString(creator.getDescriptor()), parent.getPath()));
        }
        node = parent.addLink(child);
        this.modelGraph.add(node);
        return node;
    }

    @Override
    public <T> DefaultModelRegistry configure(ModelActionRole role, ModelAction<T> action) {
        this.bind(action.getSubject(), role, action, ModelPath.ROOT);
        return this;
    }

    @Override
    public ModelRegistry apply(Class<? extends RuleSource> rules) {
        this.modelGraph.getRoot().applyToSelf(rules);
        return this;
    }

    private <T> void bind(ModelActionRole role, ModelAction<T> mutator, ModelPath scope) {
        this.bind(mutator.getSubject(), role, mutator, scope);
    }

    private <T> void bind(ModelReference<T> subject, ModelActionRole role, ModelAction<T> mutator, ModelPath scope) {
        if (this.reset) {
            return;
        }
        MutatorRuleBinder<T> binder = new MutatorRuleBinder<T>(subject, role, mutator, scope, this.binders);
        this.pendingMutatorBinders.add(binder);
    }

    private void flushPendingMutatorBinders() {
        Iterator<MutatorRuleBinder<?>> iterator = this.pendingMutatorBinders.iterator();
        while (iterator.hasNext()) {
            MutatorRuleBinder<?> binder = iterator.next();
            iterator.remove();
            this.bindMutatorSubject(binder);
        }
    }

    private <T> void bindMutatorSubject(final MutatorRuleBinder<T> binder) {
        ModelCreationListener listener = this.listener(binder.getDescriptor(), binder.getSubjectReference(), binder.getScope(), true, (Action<? super ModelNodeInternal>)new Action<ModelNodeInternal>(){

            public void execute(ModelNodeInternal subject) {
                if (!subject.canApply(binder.getRole())) {
                    throw new IllegalStateException(String.format("Cannot add %s rule '%s' for model element '%s' when element is in state %s.", new Object[]{binder.getRole(), binder.getAction().getDescriptor(), subject.getPath(), subject.getState()}));
                }
                DefaultModelRegistry.this.unboundSubjectMutatorBinders.remove(binder);
                binder.bindSubject(subject);
                subject.addMutatorBinder(binder.getRole(), binder);
            }
        });
        this.registerListener(listener);
    }

    private void bindInputs(final RuleBinder binder) {
        if (!binder.isBindingInputs()) {
            binder.setBindingInputs(true);
            List<ModelReference<?>> inputReferences = binder.getInputReferences();
            for (int i = 0; i < inputReferences.size(); ++i) {
                final int finalI = i;
                ModelReference<?> input = inputReferences.get(i);
                ModelPath effectiveScope = input.getPath() == null ? ModelPath.ROOT : binder.getScope();
                this.registerListener(this.listener(binder.getDescriptor(), input, effectiveScope, false, (Action<? super ModelNodeInternal>)new Action<ModelNodeInternal>(){

                    public void execute(ModelNodeInternal modelNode) {
                        binder.bindInput(finalI, modelNode);
                    }
                }));
                this.tryForceBind(binder);
            }
        }
    }

    private ModelCreationListener listener(ModelRuleDescriptor descriptor, ModelReference<?> reference, ModelPath scope, boolean writable, Action<? super ModelNodeInternal> bindAction) {
        if (reference.getPath() != null) {
            return new PathBinderCreationListener(descriptor, reference, scope, writable, bindAction);
        }
        return new OneOfTypeBinderCreationListener(descriptor, reference, scope, writable, bindAction);
    }

    @Override
    public <T> T realize(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.require(path), "get(ModelPath, ModelType)");
    }

    @Override
    public ModelNode atState(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, false);
    }

    @Override
    public ModelNode atStateOrLater(ModelPath path, ModelNode.State state) {
        return this.atStateOrMaybeLater(path, state, true);
    }

    private ModelNode atStateOrMaybeLater(ModelPath path, ModelNode.State state, boolean laterOk) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return null;
        }
        this.transition(node, state, laterOk);
        return node;
    }

    @Override
    public <T> T find(ModelPath path, ModelType<T> type) {
        return this.toType(type, this.get(path), "find(ModelPath, ModelType)");
    }

    private <T> T toType(ModelType<T> type, ModelNodeInternal node, String msg) {
        if (node == null) {
            return null;
        }
        return this.assertView(node, type, null, msg, new Object[0]).getInstance();
    }

    @Override
    public ModelNode realizeNode(ModelPath path) {
        return this.require(path);
    }

    private void registerListener(ModelCreationListener listener) {
        this.modelGraph.addListener(listener);
    }

    @Override
    public void remove(ModelPath path) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return;
        }
        Iterable<? extends ModelNode> dependents = node.getDependents();
        if (!Iterables.isEmpty(dependents)) {
            throw new RuntimeException("Tried to remove model " + path + " but it is depended on by: " + Joiner.on((String)", ").join(dependents));
        }
        this.modelGraph.remove(node);
    }

    @Override
    public ModelRegistry createOrReplace(ModelCreator newCreator) {
        ModelPath path = newCreator.getPath();
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            ModelNodeInternal parent = this.modelGraph.find(path.getParent());
            if (parent == null) {
                throw new IllegalStateException("Cannot create '" + path + "' as its parent node does not exist");
            }
            parent.addLink(newCreator);
        } else {
            this.replace(newCreator);
        }
        return this;
    }

    @Override
    public ModelRegistry replace(ModelCreator newCreator) {
        ModelNodeInternal node = this.modelGraph.find(newCreator.getPath());
        if (node == null) {
            throw new IllegalStateException("can not replace node " + newCreator.getPath() + " as it does not exist");
        }
        node.replaceCreatorRuleBinder(this.toCreatorBinder(newCreator));
        return this;
    }

    private ModelNode selfCloseAncestryAndSelf(ModelPath path) {
        ModelPath parent = path.getParent();
        if (parent != null && this.selfCloseAncestryAndSelf(parent) == null) {
            return null;
        }
        return this.atStateOrLater(path, ModelNode.State.SelfClosed);
    }

    @Override
    public void bindAllReferences() throws UnboundModelRulesException {
        this.flushPendingMutatorBinders();
        if (this.binders.isEmpty()) {
            return;
        }
        boolean newInputsBound = true;
        while (!this.binders.isEmpty() && newInputsBound) {
            RuleBinder[] unboundBinders;
            newInputsBound = false;
            for (RuleBinder binder : unboundBinders = this.binders.toArray(new RuleBinder[this.binders.size()])) {
                this.tryForceBind(binder);
                newInputsBound = newInputsBound || binder.isBound();
            }
        }
        if (!this.binders.isEmpty()) {
            TreeSet<RuleBinder> sortedBinders = new TreeSet<RuleBinder>(new Comparator<RuleBinder>(){

                @Override
                public int compare(RuleBinder o1, RuleBinder o2) {
                    return o1.getDescriptor().toString().compareTo(o2.getDescriptor().toString());
                }
            });
            sortedBinders.addAll(this.binders);
            throw this.unbound(sortedBinders);
        }
    }

    private UnboundModelRulesException unbound(Iterable<RuleBinder> binders) {
        ModelPathSuggestionProvider suggestionsProvider = new ModelPathSuggestionProvider(this.modelGraph.getFlattened().keySet());
        List<? extends UnboundRule> unboundRules = new UnboundRulesProcessor(binders, suggestionsProvider).process();
        return new UnboundModelRulesException(unboundRules);
    }

    private ModelNodeInternal require(ModelPath path) {
        ModelNodeInternal node = this.get(path);
        if (node == null) {
            throw new IllegalStateException("No model node at '" + path + "'");
        }
        return node;
    }

    @Override
    public ModelNode.State state(ModelPath path) {
        ModelNodeInternal modelNode = this.modelGraph.find(path);
        return modelNode == null ? null : modelNode.getState();
    }

    private ModelNodeInternal get(ModelPath path) {
        ModelNodeInternal node = this.modelGraph.find(path);
        if (node == null) {
            return null;
        }
        this.close(node);
        return node;
    }

    private void close(ModelNodeInternal node) {
        this.transition(node, ModelNode.State.GraphClosed, false);
    }

    private void transition(ModelNodeInternal node, ModelNode.State desired, boolean laterOk) {
        ModelPath path = node.getPath();
        ModelNode.State state = node.getState();
        LOGGER.debug("Transitioning model element '{}' from state {} to {}", new Object[]{path, state.name(), desired.name()});
        if (desired.ordinal() < state.ordinal()) {
            if (laterOk) {
                return;
            }
            throw new IllegalStateException("Cannot lifecycle model node '" + path + "' to state " + desired.name() + " as it is already at " + state.name());
        }
        if (state == desired) {
            return;
        }
        if (state == ModelNode.State.Known && desired.ordinal() >= ModelNode.State.Created.ordinal()) {
            CreatorRuleBinder creatorBinder = node.getCreatorBinder();
            if (creatorBinder != null) {
                this.forceBind(creatorBinder);
            }
            this.doCreate(node, creatorBinder);
            node.notifyFired(creatorBinder);
            node.setState(ModelNode.State.Created);
            if (desired == ModelNode.State.Created) {
                return;
            }
        }
        if (!this.fireMutations(node, path, state, ModelActionRole.Defaults, ModelNode.State.DefaultsApplied, desired)) {
            return;
        }
        if (!this.fireMutations(node, path, state, ModelActionRole.Initialize, ModelNode.State.Initialized, desired)) {
            return;
        }
        if (!this.fireMutations(node, path, state, ModelActionRole.Mutate, ModelNode.State.Mutated, desired)) {
            return;
        }
        if (!this.fireMutations(node, path, state, ModelActionRole.Finalize, ModelNode.State.Finalized, desired)) {
            return;
        }
        if (!this.fireMutations(node, path, state, ModelActionRole.Validate, ModelNode.State.SelfClosed, desired)) {
            return;
        }
        if (desired.ordinal() >= ModelNode.State.GraphClosed.ordinal()) {
            for (ModelNodeInternal modelNodeInternal : node.getLinks()) {
                this.close(modelNodeInternal);
            }
            node.setState(ModelNode.State.GraphClosed);
        }
        LOGGER.debug("Finished transitioning model element {} from state {} to {}", new Object[]{path, state.name(), desired.name()});
    }

    private boolean forceBindReference(ModelReference<?> reference, ModelBinding<?> binding, ModelPath scope) {
        if (binding == null) {
            if (reference.getPath() == null) {
                this.selfCloseAncestryAndSelf(scope);
            } else {
                this.selfCloseAncestryAndSelf(reference.getPath().getParent());
            }
            return true;
        }
        return false;
    }

    private boolean tryForceBind(RuleBinder binder) {
        if (binder.isBound()) {
            return false;
        }
        this.bindInputs(binder);
        boolean boundSomething = false;
        ModelPath scope = binder.getScope();
        if (binder.getSubjectReference() != null && binder.getSubjectBinding() == null && this.forceBindReference(binder.getSubjectReference(), binder.getSubjectBinding(), scope)) {
            boundSomething = binder.getSubjectBinding() != null;
        }
        for (int i = 0; i < binder.getInputReferences().size(); ++i) {
            if (!this.forceBindReference(binder.getInputReferences().get(i), binder.getInputBindings().get(i), scope)) continue;
            boundSomething = boundSomething || binder.getInputBindings().get(i) != null;
        }
        return boundSomething;
    }

    private void forceBind(RuleBinder binder) {
        this.tryForceBind(binder);
        if (!binder.isBound()) {
            throw this.unbound(Collections.singleton(binder));
        }
    }

    private boolean fireMutations(ModelNodeInternal node, ModelPath path, ModelNode.State originalState, ModelActionRole type, ModelNode.State to, ModelNode.State desired) {
        ModelNode.State nodeState = node.getState();
        if (nodeState.ordinal() >= to.ordinal()) {
            return nodeState.ordinal() < desired.ordinal();
        }
        this.flushPendingMutatorBinders();
        for (MutatorRuleBinder<?> binder : node.getMutatorBinders(type)) {
            this.forceBind(binder);
            this.fireMutation(binder);
            this.flushPendingMutatorBinders();
            node.notifyFired(binder);
        }
        node.setState(to);
        if (to == desired) {
            LOGGER.debug("Finished transitioning model element {} from state {} to {}", new Object[]{path, originalState.name(), desired.name()});
            return false;
        }
        return true;
    }

    private <T> ModelView<? extends T> assertView(ModelNodeInternal node, ModelType<T> targetType, @Nullable ModelRuleDescriptor descriptor, String msg, Object ... msgArgs) {
        ModelAdapter adapter = node.getAdapter();
        ModelView<T> view = adapter.asReadOnly(targetType, node, descriptor);
        if (view == null) {
            throw new IllegalArgumentException("Model node '" + node.getPath().toString() + "' is not compatible with requested " + targetType + " (operation: " + String.format(msg, msgArgs) + ")");
        }
        return view;
    }

    private <T> ModelView<? extends T> assertView(ModelNodeInternal node, ModelReference<T> reference, ModelRuleDescriptor sourceDescriptor, List<ModelView<?>> inputs) {
        ModelAdapter adapter = node.getAdapter();
        ModelView<T> view = adapter.asWritable(reference.getType(), node, sourceDescriptor, inputs);
        if (view == null) {
            throw new IllegalArgumentException("Cannot project model element " + node.getPath() + " to writable type '" + reference.getType() + "' for rule " + sourceDescriptor);
        }
        return view;
    }

    private ModelNodeInternal doCreate(ModelNodeInternal node, CreatorRuleBinder boundCreator) {
        ModelCreator creator = boundCreator.getCreator();
        List<ModelView<?>> views = this.toViews(boundCreator.getInputBindings(), boundCreator.getCreator());
        LOGGER.debug("Creating {} using {}", (Object)node.getPath(), (Object)creator.getDescriptor());
        try {
            creator.create(node, views);
        }
        catch (Exception e) {
            throw new ModelRuleExecutionException(creator.getDescriptor(), e);
        }
        return node;
    }

    private <T> void fireMutation(MutatorRuleBinder<T> boundMutator) {
        List<ModelView<?>> inputs = this.toViews(boundMutator.getInputBindings(), boundMutator.getAction());
        ModelNodeInternal node = boundMutator.getSubjectBinding().getNode();
        ModelAction<T> mutator = boundMutator.getAction();
        ModelRuleDescriptor descriptor = mutator.getDescriptor();
        LOGGER.debug("Mutating {} using {}", (Object)node.getPath(), (Object)mutator.getDescriptor());
        ModelView<T> view = this.assertView(node, boundMutator.getSubjectReference(), descriptor, inputs);
        try {
            mutator.execute(node, view.getInstance(), inputs);
        }
        catch (Exception e) {
            throw new ModelRuleExecutionException(descriptor, e);
        }
        finally {
            view.close();
        }
    }

    private List<ModelView<?>> toViews(List<ModelBinding<?>> bindings, ModelRule modelRule) {
        ModelView[] array = new ModelView[bindings.size()];
        int i = 0;
        for (ModelBinding<?> binding : bindings) {
            this.closeRuleBinding(modelRule, binding);
            ModelPath path = binding.getNode().getPath();
            ModelNodeInternal element = this.require(path);
            ModelView<?> view = this.assertView(element, binding.getReference().getType(), modelRule.getDescriptor(), "toViews", new Object[0]);
            array[i++] = view;
        }
        List<ModelView<?>> views = Arrays.asList(array);
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRuleBinding(ModelRule modelRule, ModelBinding<?> binding) {
        if (this.rulesWithInputsBeingClosed.containsKey(modelRule)) {
            throw this.ruleCycle(modelRule);
        }
        this.rulesWithInputsBeingClosed.put(modelRule, binding);
        try {
            this.close(binding.getNode());
        }
        finally {
            this.rulesWithInputsBeingClosed.remove(modelRule);
        }
    }

    private ConfigurationCycleException ruleCycle(ModelRule cycleStartRule) {
        boolean cycleStartFound = false;
        String indent = "  ";
        StringBuilder prefix = new StringBuilder(indent);
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("A cycle has been detected in model rule dependencies. References forming the cycle:");
        for (Map.Entry<ModelRule, ModelBinding<?>> ruleInputInClosing : this.rulesWithInputsBeingClosed.entrySet()) {
            ModelRule rule = ruleInputInClosing.getKey();
            ModelRuleDescriptor ruleDescriptor = rule.getDescriptor();
            ModelBinding<?> binding = ruleInputInClosing.getValue();
            if (cycleStartFound) {
                this.reportRuleInputBeingClosed(indent, prefix, writer, ruleDescriptor, binding);
                continue;
            }
            if (!rule.equals(cycleStartRule)) continue;
            cycleStartFound = true;
            this.reportRuleInputBeingClosed(indent, prefix, writer, ruleDescriptor, binding);
        }
        writer.print(cycleStartRule.getDescriptor().toString());
        return new ConfigurationCycleException(out.toString());
    }

    private void reportRuleInputBeingClosed(String indent, StringBuilder prefix, PrintWriter writer, ModelRuleDescriptor ruleDescriptor, ModelBinding<?> binding) {
        writer.print(ruleDescriptor.toString());
        String referenceDescription = binding.getReference().getDescription();
        if (referenceDescription != null) {
            writer.print(" ");
            writer.print(referenceDescription);
        }
        writer.print(" (path: ");
        writer.print(binding.getNode().getPath().toString());
        writer.print(")");
        writer.println();
        writer.print(prefix);
        writer.print("\\--- ");
        prefix.append(indent);
    }

    @Override
    public ModelNode node(ModelPath path) {
        return this.modelGraph.find(path);
    }

    @Override
    public void prepareForReuse() {
        this.reset = true;
        LinkedList ephemerals = Lists.newLinkedList();
        this.collectEphemeralChildren(this.modelGraph.getRoot(), ephemerals);
        if (ephemerals.isEmpty()) {
            LOGGER.info("No ephemeral model nodes found to reset");
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Resetting ephemeral model nodes: " + Joiner.on((String)", ").join((Iterable)ephemerals));
            }
            for (ModelNodeInternal ephemeral : ephemerals) {
                ephemeral.reset();
            }
        }
    }

    private void collectEphemeralChildren(ModelNodeInternal node, Collection<ModelNodeInternal> ephemerals) {
        for (ModelNodeInternal modelNodeInternal : node.getLinks()) {
            if (modelNodeInternal.isEphemeral()) {
                ephemerals.add(modelNodeInternal);
                continue;
            }
            this.collectEphemeralChildren(modelNodeInternal, ephemerals);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelElementNode
    extends ModelNodeInternal {
        private final Map<String, ModelNodeInternal> links;
        private Object privateData;
        private ModelType<?> privateDataType;

        public ModelElementNode(CreatorRuleBinder creatorBinder) {
            super(creatorBinder);
            this.links = Maps.newTreeMap();
        }

        @Override
        public ModelNodeInternal addLink(ModelNodeInternal node) {
            this.links.put(node.getPath().getName(), node);
            return node;
        }

        @Override
        public <T> T getPrivateData(ModelType<T> type) {
            if (this.privateData == null) {
                return null;
            }
            if (!type.isAssignableFrom(this.privateDataType)) {
                throw new ClassCastException("Cannot get private data '" + this.privateData + "' of type '" + this.privateDataType + "' as type '" + type);
            }
            return (T)Cast.uncheckedCast((Object)this.privateData);
        }

        @Override
        public Object getPrivateData() {
            return this.privateData;
        }

        @Override
        public <T> void setPrivateData(ModelType<? super T> type, T object) {
            if (!this.isMutable()) {
                throw new IllegalStateException(String.format("Cannot set value for model element '%s' as this element is not mutable.", this.getPath()));
            }
            this.privateDataType = type;
            this.privateData = object;
        }

        @Override
        public boolean hasLink(String name) {
            return this.links.containsKey(name);
        }

        @Override
        @Nullable
        public ModelNodeInternal getLink(String name) {
            return this.links.get(name);
        }

        @Override
        public Iterable<? extends ModelNodeInternal> getLinks() {
            return this.links.values();
        }

        @Override
        public int getLinkCount(ModelType<?> type) {
            int count = 0;
            for (ModelNodeInternal linked : this.links.values()) {
                if (!linked.getPromise().canBeViewedAsWritable(type)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Set<String> getLinkNames(ModelType<?> type) {
            LinkedHashSet names = Sets.newLinkedHashSet();
            for (Map.Entry<String, ModelNodeInternal> entry : this.links.entrySet()) {
                if (!entry.getValue().getPromise().canBeViewedAsWritable(type)) continue;
                names.add(entry.getKey());
            }
            return names;
        }

        @Override
        public Iterable<? extends MutableModelNode> getLinks(final ModelType<?> type) {
            return Iterables.filter(this.links.values(), (Predicate)new Predicate<ModelNodeInternal>(){

                public boolean apply(ModelNodeInternal input) {
                    return input.getPromise().canBeViewedAsWritable(type);
                }
            });
        }

        @Override
        public boolean hasLink(String name, ModelType<?> type) {
            ModelNodeInternal linked = this.getLink(name);
            return linked != null && linked.getPromise().canBeViewedAsWritable(type);
        }

        @Override
        public <T> void applyToSelf(ModelActionRole type, ModelAction<T> action) {
            if (!this.getPath().equals(action.getSubject().getPath())) {
                throw new IllegalArgumentException(String.format("Element action reference has path (%s) which does not reference this node (%s).", action.getSubject().getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.bind(action.getSubject(), type, action, ModelPath.ROOT);
        }

        @Override
        public <T> void applyToLink(ModelActionRole type, ModelAction<T> action) {
            if (!this.getPath().isDirectChild(action.getSubject().getPath())) {
                throw new IllegalArgumentException(String.format("Linked element action reference has a path (%s) which is not a child of this node (%s).", action.getSubject().getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.bind(action.getSubject(), type, action, ModelPath.ROOT);
        }

        @Override
        public void applyToLink(String name, Class<? extends RuleSource> rules) {
            this.apply(rules, this.getPath().child(name));
        }

        @Override
        public void applyToSelf(Class<? extends RuleSource> rules) {
            this.apply(rules, this.getPath());
        }

        @Override
        public <T> void applyToLinks(Class<T> type, final Class<? extends RuleSource> rules) {
            final ModelType<T> modelType = ModelType.of(type);
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                @Nullable
                public ModelPath matchParent() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> matchType() {
                    return modelType;
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    node.applyToSelf(rules);
                    return false;
                }
            });
        }

        public void apply(Class<? extends RuleSource> rules, ModelPath scope) {
            Iterable<ExtractedModelRule> extractedRules = DefaultModelRegistry.this.ruleExtractor.extract(rules);
            for (ExtractedModelRule extractedRule : extractedRules) {
                if (!extractedRule.getRuleDependencies().isEmpty()) {
                    throw new IllegalStateException("Rule source " + rules + " cannot have plugin dependencies (introduced by rule " + extractedRule + ")");
                }
                if (extractedRule.getType().equals((Object)ExtractedModelRule.Type.CREATOR)) {
                    if (scope.equals(ModelPath.ROOT)) {
                        DefaultModelRegistry.this.create(extractedRule.getCreator());
                        continue;
                    }
                    throw new InvalidModelRuleDeclarationException("Rule " + extractedRule.getCreator().getDescriptor() + " cannot be applied at the scope of model element " + scope + " as creation rules cannot be used when applying rule sources to particular elements");
                }
                if (extractedRule.getType().equals((Object)ExtractedModelRule.Type.ACTION)) {
                    DefaultModelRegistry.this.bind(extractedRule.getActionRole(), extractedRule.getAction(), scope);
                    continue;
                }
                throw new IllegalStateException("unexpected extracted rule type: " + (Object)((Object)extractedRule.getType()));
            }
        }

        @Override
        public <T> void applyToAllLinks(final ModelActionRole type, final ModelAction<T> action) {
            if (action.getSubject().getPath() != null) {
                throw new IllegalArgumentException("Linked element action reference must have null path.");
            }
            DefaultModelRegistry.this.registerListener(new ModelCreationListener(){

                @Override
                @Nullable
                public ModelPath matchParent() {
                    return ModelElementNode.this.getPath();
                }

                @Override
                @Nullable
                public ModelType<?> matchType() {
                    return action.getSubject().getType();
                }

                @Override
                public boolean onCreate(ModelNodeInternal node) {
                    DefaultModelRegistry.this.bind(ModelReference.of(node.getPath(), action.getSubject().getType()), type, action, ModelPath.ROOT);
                    return false;
                }
            });
        }

        @Override
        public void addReference(ModelCreator creator) {
            if (!this.getPath().isDirectChild(creator.getPath())) {
                throw new IllegalArgumentException(String.format("Reference element creator has a path (%s) which is not a child of this node (%s).", creator.getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.registerNode(this, new ModelReferenceNode(DefaultModelRegistry.this.toCreatorBinder(creator)));
        }

        @Override
        public void addLink(ModelCreator creator) {
            if (!this.getPath().isDirectChild(creator.getPath())) {
                throw new IllegalArgumentException(String.format("Linked element creator has a path (%s) which is not a child of this node (%s).", creator.getPath(), this.getPath()));
            }
            DefaultModelRegistry.this.registerNode(this, new ModelElementNode(DefaultModelRegistry.this.toCreatorBinder(creator)));
        }

        @Override
        public void removeLink(String name) {
            if (this.links.remove(name) != null) {
                DefaultModelRegistry.this.remove(this.getPath().child(name));
            }
        }

        @Override
        public ModelNodeInternal getTarget() {
            return this;
        }

        @Override
        public void setTarget(ModelNode target) {
            throw new UnsupportedOperationException(String.format("This node (%s) is not a reference to another node.", this.getPath()));
        }

        @Override
        public void ensureUsable() {
            DefaultModelRegistry.this.transition(this, ModelNode.State.Initialized, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelReferenceNode
    extends ModelNodeInternal {
        private ModelNodeInternal target;

        public ModelReferenceNode(CreatorRuleBinder creatorBinder) {
            super(creatorBinder);
        }

        @Override
        public ModelNodeInternal getTarget() {
            return this.target;
        }

        @Override
        public void setTarget(ModelNode target) {
            this.target = (ModelNodeInternal)target;
        }

        @Override
        public ModelNodeInternal addLink(ModelNodeInternal node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLink(ModelCreator creator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addReference(ModelCreator creator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeLink(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToSelf(ModelActionRole type, ModelAction<T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToAllLinks(ModelActionRole type, ModelAction<T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToLink(ModelActionRole type, ModelAction<T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyToLink(String name, Class<? extends RuleSource> rules) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void applyToLinks(Class<T> type, Class<? extends RuleSource> rules) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyToSelf(Class<? extends RuleSource> rules) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLinkCount(ModelType<?> type) {
            return 0;
        }

        @Override
        public Set<String> getLinkNames(ModelType<?> type) {
            return Collections.emptySet();
        }

        @Override
        @Nullable
        public MutableModelNode getLink(String name) {
            return null;
        }

        @Override
        public Iterable<? extends ModelNodeInternal> getLinks() {
            return Collections.emptySet();
        }

        @Override
        public Iterable<? extends MutableModelNode> getLinks(ModelType<?> type) {
            return Collections.emptySet();
        }

        @Override
        public boolean hasLink(String name, ModelType<?> type) {
            return false;
        }

        @Override
        public boolean hasLink(String name) {
            return false;
        }

        @Override
        public <T> T getPrivateData(ModelType<T> type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void setPrivateData(ModelType<? super T> type, T object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getPrivateData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ensureUsable() {
        }
    }
}

