/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Collection;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.RuleBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutatorRuleBinder<T>
extends RuleBinder {
    private ModelBinding<T> subjectBinding;
    private final ModelReference<T> subjectReference;
    private final ModelActionRole role;
    private final ModelAction<T> action;

    public MutatorRuleBinder(ModelReference<T> subjectReference, ModelActionRole role, ModelAction<T> action, ModelPath scope, Collection<RuleBinder> binders) {
        super(action.getInputs(), action.getDescriptor(), scope, binders);
        this.subjectReference = subjectReference;
        this.role = role;
        this.action = action;
    }

    public ModelActionRole getRole() {
        return this.role;
    }

    public ModelAction<T> getAction() {
        return this.action;
    }

    public ModelReference<T> getSubjectReference() {
        return this.subjectReference;
    }

    public ModelBinding<T> getSubjectBinding() {
        return this.subjectBinding;
    }

    public void bindSubject(ModelNodeInternal modelNode) {
        assert (this.subjectBinding == null);
        this.subjectBinding = RuleBinder.bind(this.subjectReference, modelNode);
        this.maybeFire();
    }

    @Override
    public boolean isBound() {
        return this.subjectBinding != null && super.isBound();
    }
}

