/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.model.InvalidModelRuleException;
import org.gradle.model.ModelRuleBindingException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BinderCreationListener;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.report.AmbiguousBindingReporter;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OneOfTypeBinderCreationListener
extends BinderCreationListener {
    private final Action<? super ModelNodeInternal> bindAction;
    private ModelPath boundTo;
    private ModelRuleDescriptor boundToCreator;
    private final ModelPath scope;

    public OneOfTypeBinderCreationListener(ModelRuleDescriptor descriptor, ModelReference<?> reference, ModelPath scope, boolean writable, Action<? super ModelNodeInternal> bindAction) {
        super(descriptor, reference, writable);
        this.bindAction = bindAction;
        this.scope = scope;
    }

    @Override
    @Nullable
    public ModelPath matchParent() {
        return null;
    }

    @Override
    public ModelPath matchScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public ModelType<?> matchType() {
        return this.reference.getType();
    }

    @Override
    public boolean onCreate(ModelNodeInternal node) {
        ModelRuleDescriptor creatorDescriptor = node.getDescriptor();
        ModelPath path = node.getPath();
        if (this.boundTo != null) {
            throw new InvalidModelRuleException(this.descriptor, (Throwable)((Object)new ModelRuleBindingException(new AmbiguousBindingReporter(this.reference, this.boundTo, this.boundToCreator, path, creatorDescriptor).asString())));
        }
        this.bindAction.execute((Object)node);
        this.boundTo = path;
        this.boundToCreator = creatorDescriptor;
        return false;
    }
}

