/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.model.InvalidModelRuleException;
import org.gradle.model.ModelRuleBindingException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BinderCreationListener;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.report.IncompatibleTypeReferenceReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathBinderCreationListener
extends BinderCreationListener {
    private final Action<? super ModelNodeInternal> bindAction;
    private final ModelPath path;

    public PathBinderCreationListener(ModelRuleDescriptor descriptor, ModelReference<?> reference, ModelPath scope, boolean writable, Action<? super ModelNodeInternal> bindAction) {
        super(descriptor, reference, writable);
        this.bindAction = bindAction;
        this.path = scope.descendant(reference.getPath());
    }

    @Override
    @Nullable
    public ModelPath matchPath() {
        return this.path;
    }

    @Override
    public boolean onCreate(ModelNodeInternal node) {
        ModelRuleDescriptor creatorDescriptor = node.getDescriptor();
        ModelPromise promise = node.getPromise();
        if (this.isTypeCompatible(promise)) {
            this.bindAction.execute((Object)node);
            return true;
        }
        throw new InvalidModelRuleException(this.descriptor, (Throwable)((Object)new ModelRuleBindingException(IncompatibleTypeReferenceReporter.of(creatorDescriptor, promise, this.reference, this.writable).asString())));
    }
}

