/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class RuleBinder {
    private final ModelRuleDescriptor descriptor;
    private final List<? extends ModelReference<?>> inputReferences;
    private final ModelPath scope;
    private final Collection<RuleBinder> binders;
    private boolean bindingInputs;
    private int inputsBound;
    private List<ModelBinding<?>> inputBindings;

    public RuleBinder(List<? extends ModelReference<?>> inputReferences, ModelRuleDescriptor descriptor, ModelPath scope, Collection<RuleBinder> binders) {
        this.inputReferences = inputReferences;
        this.descriptor = descriptor;
        this.scope = scope;
        this.binders = binders;
        List<Object> list = this.inputBindings = inputReferences.isEmpty() ? Collections.emptyList() : Arrays.asList(new ModelBinding[inputReferences.size()]);
        if (!this.isBound()) {
            binders.add(this);
        }
    }

    public boolean isBindingInputs() {
        return this.bindingInputs;
    }

    public void setBindingInputs(boolean bindingInputs) {
        this.bindingInputs = bindingInputs;
    }

    public List<? extends ModelReference<?>> getInputReferences() {
        return this.inputReferences;
    }

    public ModelBinding<?> getSubjectBinding() {
        return null;
    }

    public ModelReference<?> getSubjectReference() {
        return null;
    }

    public List<ModelBinding<?>> getInputBindings() {
        return this.inputBindings;
    }

    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ModelPath getScope() {
        return this.scope;
    }

    public void bindInput(int i, ModelNodeInternal modelNode) {
        assert (this.inputBindings.get(i) == null);
        assert (this.inputsBound < this.inputBindings.size());
        this.inputBindings.set(i, RuleBinder.bind(this.inputReferences.get(i), modelNode));
        ++this.inputsBound;
        this.maybeFire();
    }

    protected void maybeFire() {
        if (this.isBound()) {
            this.binders.remove(this);
        }
    }

    public boolean isBound() {
        return this.inputsBound == this.inputReferences.size();
    }

    static <I> ModelBinding<I> bind(ModelReference<I> reference, ModelNodeInternal modelNode) {
        return ModelBinding.of(reference, modelNode);
    }
}

